/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.spring.processor;

import cn.mapway.spring.processor.module.AllModules;
import cn.mapway.spring.processor.module.ApiModuleDefine;
import cn.mapway.spring.processor.module.FieldDefine;
import cn.mapway.spring.processor.module.ModulePara;
import cn.mapway.spring.processor.module.StringTools;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import elemental2.core.JsArray;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class TypeMirrorVisitor
extends SimpleTypeVisitor8<TypeName, String> {
    Log log = Logs.getLog(TypeMirrorVisitor.class);
    ProcessingEnvironment env;

    public TypeMirrorVisitor(ProcessingEnvironment environment) {
        this.env = environment;
    }

    public TypeName parse(String packageName, TypeMirror typeMirror) {
        return typeMirror.accept(this, packageName);
    }

    @Override
    public TypeName visitArray(ArrayType t, String packageName) {
        TypeMirror com = t.getComponentType();
        TypeName transMirror = this.parse(packageName, com);
        return ArrayTypeName.of((TypeName)transMirror);
    }

    public List<? extends Element> findAllFields(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).collect(Collectors.toList());
    }

    String getQName(Element element) {
        PackageElement pkg = this.env.getElementUtils().getPackageOf(element);
        return pkg.getQualifiedName() + "." + element.getSimpleName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeName visitDeclared(DeclaredType t, String packageName) {
        TypeName outerName = TypeName.get((TypeMirror)t);
        Element element = t.asElement();
        String qname = this.getQName(element);
        if (element.getKind().equals((Object)ElementKind.CLASS)) {
            if (!this.isSystem(qname)) {
                outerName = this.handleModule(packageName, false, qname, element);
            }
        } else if (element.getKind().equals((Object)ElementKind.INTERFACE) && !this.isSystem(qname)) {
            outerName = this.handleModule(packageName, true, qname, element);
        }
        if (AllModules.isPredefinedType(qname)) {
            outerName = AllModules.getTranslatePattern(qname);
        }
        List<? extends TypeMirror> typeArguments = t.getTypeArguments();
        ArrayList<TypeName> typeArguments2 = new ArrayList<TypeName>();
        for (TypeMirror typeMirror : typeArguments) {
            typeArguments2.add(this.parse(packageName, typeMirror));
        }
        if (Lang.isNotEmpty(typeArguments2)) {
            void var9_15;
            void var9_13;
            TypeName[] types = typeArguments2.toArray(new TypeName[typeArguments2.size()]);
            String string = "";
            if (outerName instanceof ParameterizedTypeName) {
                String string2 = ((ParameterizedTypeName)outerName).rawType.canonicalName();
            } else {
                String string3 = outerName.toString();
            }
            if (var9_13.startsWith("java.util.List") || var9_13.startsWith("java.util.ArrayList")) {
                String string4 = JsArray.class.getCanonicalName();
            }
            String[] vs = StringTools.splitLast((String)var9_15, '.');
            outerName = this.isSystem((String)var9_15) ? ParameterizedTypeName.get((ClassName)ClassName.get((String)vs[0], (String)vs[1], (String[])new String[0]), (TypeName[])types) : ParameterizedTypeName.get((ClassName)ClassName.get((String)packageName, (String)vs[1], (String[])new String[0]), (TypeName[])types);
        }
        return outerName;
    }

    private boolean isSystem(String qname) {
        if (qname.startsWith("java.lang") || qname.startsWith("java.util") || qname.startsWith("elemental2.") || qname.startsWith("java.sql.")) {
            return true;
        }
        if (AllModules.isPredefinedType(qname)) {
            return true;
        }
        ArrayList omittedClasses = Lang.list((Object[])new String[]{String.class.getCanonicalName(), java.util.Date.class.getCanonicalName(), Date.class.getCanonicalName(), Serializable.class.getCanonicalName(), IsSerializable.class.getCanonicalName(), List.class.getCanonicalName(), ArrayList.class.getCanonicalName()});
        return omittedClasses.contains(qname);
    }

    boolean isObject(String qname) {
        return "java.lang.Object".equals(qname);
    }

    private TypeName handleModule(final String packageName, boolean isInterface, String qname, Element element) {
        TypeName prepareType = AllModules.getTranslatePattern(qname);
        if (prepareType != null) {
            return prepareType;
        }
        ApiModuleDefine module = AllModules.getInstance().getModule(qname);
        boolean needParseFields = true;
        if (module == null || module.translateName == null) {
            boolean bl = needParseFields = module == null;
            if (module == null) {
                module = new ApiModuleDefine(qname);
                AllModules.getInstance().put(module);
            }
            TypeName translationSuperMirror = null;
            TypeMirror superclass = ((TypeElement)element).getSuperclass();
            if (superclass.getKind().equals((Object)TypeKind.DECLARED) && !this.isSystem(superclass.toString()) && !this.isObject(superclass.toString()) && (translationSuperMirror = this.parse(packageName, superclass)) != null) {
                module.setTranslateSuper(translationSuperMirror);
            }
            List<? extends TypeMirror> interfaces = ((TypeElement)element).getInterfaces();
            for (int i = 0; i < interfaces.size(); ++i) {
                module.translateImpls.add(this.parse(packageName, interfaces.get(i)));
            }
            List<? extends TypeParameterElement> typeParameters = ((TypeElement)element).getTypeParameters();
            ArrayList<TypeName> translateParameters = new ArrayList<TypeName>();
            if (typeParameters.size() > 0) {
                for (final TypeParameterElement typeParameterElement : typeParameters) {
                    final ModulePara modulePara = new ModulePara(typeParameterElement.getSimpleName().toString());
                    TypeName translatePara = typeParameterElement.asType().accept(new SimpleTypeVisitor6<TypeName, String>(){

                        @Override
                        public TypeName visitTypeVariable(TypeVariable t, String pname) {
                            List<TypeName> up = t.getUpperBound().accept(new SimpleTypeVisitor6<List<TypeName>, String>(){

                                @Override
                                public List<TypeName> visitIntersection(IntersectionType t, String pname) {
                                    ArrayList<TypeName> translateup = new ArrayList<TypeName>();
                                    for (TypeMirror typeMirror : t.getBounds()) {
                                        if (TypeMirrorVisitor.this.isObject(typeMirror.toString())) continue;
                                        modulePara.upBound.add(typeMirror.toString());
                                        TypeName parse = TypeMirrorVisitor.this.parse(pname, typeMirror);
                                        translateup.add(parse);
                                    }
                                    return translateup;
                                }

                                @Override
                                public List<TypeName> visitDeclared(DeclaredType t, String pname) {
                                    if (!TypeMirrorVisitor.this.isObject(t.toString())) {
                                        modulePara.upBound.add(t.toString());
                                        return Lang.list((Object[])new TypeName[]{TypeMirrorVisitor.this.parse(pname, t)});
                                    }
                                    return new ArrayList<TypeName>();
                                }
                            }, packageName);
                            TypeName low = t.getLowerBound().accept(new SimpleTypeVisitor6<TypeName, String>(){

                                @Override
                                public TypeName visitDeclared(DeclaredType t, String pname) {
                                    modulePara.lowerBound.add(t.toString());
                                    return TypeMirrorVisitor.this.parse(packageName, t);
                                }
                            }, packageName);
                            if (Lang.isNotEmpty(up)) {
                                TypeName[] types = up.toArray(new TypeName[up.size()]);
                                return TypeVariableName.get((String)typeParameterElement.getSimpleName().toString(), (TypeName[])types);
                            }
                            if (Lang.isNotEmpty((Object)low)) {
                                return TypeVariableName.get((String)typeParameterElement.getSimpleName().toString(), (TypeName[])new TypeName[]{low});
                            }
                            return TypeVariableName.get((String)typeParameterElement.getSimpleName().toString());
                        }
                    }, null);
                    translateParameters.add(translatePara);
                    module.parameters.add(modulePara);
                }
            }
            if (!isInterface) {
                module.isInterface = false;
                if (needParseFields) {
                    List<? extends Element> fields = this.findAllFields((TypeElement)element);
                    for (VariableElement variableElement : fields) {
                        String comment;
                        Object constantExpression;
                        FieldDefine fieldDefine = new FieldDefine();
                        fieldDefine.name = variableElement.getSimpleName().toString();
                        fieldDefine.qTypeName = this.getQName(variableElement);
                        fieldDefine.tType = this.parse(packageName, variableElement.asType());
                        fieldDefine.isStatic = variableElement.getModifiers().contains((Object)Modifier.STATIC);
                        if (fieldDefine.isStatic && (constantExpression = variableElement.getConstantValue()) != null) {
                            fieldDefine.initValue = fieldDefine.tType.toString().endsWith("String") ? "\"" + constantExpression.toString() + "\"" : constantExpression.toString();
                        }
                        if (Strings.isNotBlank((CharSequence)(comment = this.env.getElementUtils().getDocComment(variableElement)))) {
                            fieldDefine.summary = comment;
                        } else {
                            List<? extends AnnotationMirror> allAnnotationMirrors = this.env.getElementUtils().getAllAnnotationMirrors(variableElement);
                            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                                String com = this.env.getElementUtils().getDocComment(variableElement);
                                if (!Strings.isNotBlank((CharSequence)com)) continue;
                                fieldDefine.summary = com;
                                break;
                            }
                        }
                        module.fields.add(fieldDefine);
                    }
                }
            } else {
                module.isInterface = true;
            }
            module.packageName = packageName;
            String name = element.toString();
            String[] stringArray = StringTools.splitLast(name, '.');
            TypeName[] typeNameArray = translateParameters.toArray(new TypeName[translateParameters.size()]);
            if (this.isSystem(stringArray[0])) {
                if (name.equals("java.util.List") || name.equals("java.util.ArrayList")) {
                    stringArray[0] = JsArray.class.getPackage().getName();
                    stringArray[1] = JsArray.class.getSimpleName();
                }
            } else {
                stringArray[0] = packageName;
            }
            module.translateName = typeNameArray.length > 0 ? ParameterizedTypeName.get((ClassName)ClassName.get((String)stringArray[0], (String)stringArray[1], (String[])new String[0]), (TypeName[])typeNameArray) : ClassName.get((String)stringArray[0], (String)stringArray[1], (String[])new String[0]);
        }
        return module.translateName;
    }

    @Override
    public TypeName visitExecutable(ExecutableType t, String packageName) {
        return TypeName.get((TypeMirror)t);
    }

    @Override
    public TypeName visitPrimitive(PrimitiveType t, String packageName) {
        return TypeName.get((TypeMirror)t).box();
    }

    @Override
    public TypeName visitTypeVariable(TypeVariable t, String packageName) {
        return TypeName.get((TypeMirror)t);
    }

    @Override
    public TypeName visitWildcard(WildcardType t, String packageName) {
        return TypeName.get((TypeMirror)t);
    }

    @Override
    public TypeName visitNoType(NoType t, String s) {
        return TypeName.VOID;
    }

    @Override
    public TypeName visitNull(NullType t, String s) {
        return TypeName.VOID;
    }
}

