/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark;

import cn.mingfer.benchmark.Args;
import cn.mingfer.benchmark.Benchmark;
import cn.mingfer.benchmark.Executable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class CountBenchmark
extends Benchmark<CountBenchmark> {
    private final int count;
    private int warmUp = 0;

    public CountBenchmark warmUp(int warmUp) {
        this.warmUp = Args.notNegative(warmUp, "warmUp");
        return this;
    }

    protected CountBenchmark(int count, int threads, Executable executable) {
        super(threads, executable);
        this.count = count;
    }

    @Override
    protected CountDownLatch prepare(CountDownLatch latch) {
        CountDownLatch wait = new CountDownLatch(this.threads);
        CountDownLatch warmUpWait = new CountDownLatch(this.threads);
        int warmUpCount = this.warmUp;
        AtomicInteger warmUpExecutedCount = new AtomicInteger();
        AtomicInteger executedCount = new AtomicInteger();
        for (int i = 0; i < this.threads; ++i) {
            warmUpWait.countDown();
            this.service.execute(() -> {
                try {
                    warmUpWait.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                while (warmUpExecutedCount.incrementAndGet() <= warmUpCount) {
                    this.execute();
                }
                try {
                    wait.countDown();
                    wait.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                while (executedCount.incrementAndGet() <= this.count) {
                    this.execute();
                }
                latch.countDown();
            });
        }
        return wait;
    }
}

