/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark.junit5;

import cn.mingfer.benchmark.Benchmark;
import cn.mingfer.benchmark.CountBenchmark;
import cn.mingfer.benchmark.junit5.BenchmarkCount;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class BenchmarkCountExtension
implements InvocationInterceptor {
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context) throws Throwable {
        Optional<BenchmarkCount> benchmark = this.findBenchmark(context);
        if (benchmark.isPresent() && invocationContext.getTarget().isPresent()) {
            String displayName = context.getDisplayName();
            BenchmarkCount annotation = benchmark.get();
            invocation.skip();
            ((CountBenchmark)Benchmark.ofCount(annotation.count(), annotation.threads(), () -> ReflectionUtils.invokeMethod((Method)((Method)invocationContext.getExecutable()), invocationContext.getTarget().get(), (Object[])invocationContext.getArguments().toArray(new Object[0]))).name(displayName)).warmUp(annotation.warmUp()).benchmark();
        } else {
            super.interceptTestMethod(invocation, invocationContext, context);
        }
    }

    public Optional<BenchmarkCount> findBenchmark(ExtensionContext context) {
        if (!context.getTestMethod().isPresent() || !context.getTestInstance().isPresent()) {
            return Optional.empty();
        }
        Method testMethod = (Method)context.getTestMethod().get();
        return AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, BenchmarkCount.class);
    }
}

