/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark.junit5;

import cn.mingfer.benchmark.Benchmark;
import cn.mingfer.benchmark.TimingBenchmark;
import cn.mingfer.benchmark.junit5.BenchmarkTiming;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class BenchmarkTimingExtension
implements InvocationInterceptor {
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext context) throws Throwable {
        Optional<BenchmarkTiming> benchmark = this.findBenchmark(context);
        if (benchmark.isPresent() && invocationContext.getTarget().isPresent()) {
            String displayName = context.getDisplayName();
            BenchmarkTiming annotation = benchmark.get();
            invocation.skip();
            ((TimingBenchmark)Benchmark.ofTiming(Duration.ofSeconds(annotation.unit().toSeconds(annotation.duration())), annotation.threads(), () -> ReflectionUtils.invokeMethod((Method)((Method)invocationContext.getExecutable()), invocationContext.getTarget().get(), (Object[])invocationContext.getArguments().toArray(new Object[0]))).name(displayName)).warmUp(Duration.ofSeconds(annotation.warmUpSeconds())).benchmark();
        } else {
            super.interceptTestMethod(invocation, invocationContext, context);
        }
    }

    public Optional<BenchmarkTiming> findBenchmark(ExtensionContext context) {
        if (!context.getTestMethod().isPresent() || !context.getTestInstance().isPresent()) {
            return Optional.empty();
        }
        Method testMethod = (Method)context.getTestMethod().get();
        return AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, BenchmarkTiming.class);
    }
}

