/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark.reporter;

import cn.mingfer.benchmark.Benchmark;
import cn.mingfer.benchmark.reporter.Reporter;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ConsoleReporter
extends Reporter {
    protected static final Reporter CONSOLE = new ConsoleReporter();
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private Duration frequency = Duration.ofSeconds(1L);
    private ScheduledFuture<?> future;
    private boolean statistics = false;

    public ConsoleReporter datetimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = Objects.requireNonNull(dateTimeFormatter);
        return this;
    }

    public ConsoleReporter frequency(Duration frequency) {
        this.frequency = Objects.requireNonNull(frequency);
        return this;
    }

    @Override
    public void reportStart(long timestamp, Benchmark<?> benchmark) {
        super.reportStart(timestamp, benchmark);
        Thread thread = new Thread(() -> this.statistics(benchmark));
        Runtime.getRuntime().addShutdownHook(thread);
        String format = "%s success: %09d  failed: %06d  TPS: %06d RTT: %03.03fms%n";
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r, "simple-benchmark-report-thread");
            t.setDaemon(true);
            return t;
        });
        this.future = executor.scheduleWithFixedDelay(new Runnable(){
            private long lastCounts = 0L;
            private long lastTimeConsuming = 0L;

            @Override
            public void run() {
                try {
                    long success = ConsoleReporter.this.successCounts.get();
                    long failed = ConsoleReporter.this.failedCounts.get();
                    long timeout = ConsoleReporter.this.timeConsuming.get();
                    long tps = success - this.lastCounts;
                    float rtt = (float)(tps == 0L ? 0.0 : (double)(timeout - this.lastTimeConsuming) / 1000.0 / (double)tps);
                    this.lastCounts = success;
                    this.lastTimeConsuming = timeout;
                    System.out.printf("%s success: %09d  failed: %06d  TPS: %06d RTT: %03.03fms%n", ConsoleReporter.this.dateTimeFormatter.format(LocalDateTime.now()), success, failed, tps, Float.valueOf(rtt));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.frequency.getSeconds(), this.frequency.getSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public void statistics(Benchmark<?> benchmark) {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (!this.statistics) {
            long duration = System.currentTimeMillis() - this.startTimestamp;
            try {
                Thread.sleep(this.frequency.toMillis() + 10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            long success = this.successCounts.get();
            long failed = this.failedCounts.get();
            double rtt = success == 0L ? 0.0 : (double)this.timeConsuming.get() / 1000.0 / (double)success;
            String result = "              Name: " + benchmark.name() + "\n           Threads: " + benchmark.threads() + "\n          Duration: " + (double)duration / 1000.0 + "s\n       Total Count: " + (success + failed) + "\n     Success Count: " + success + "\n      Failed Count: " + failed + "\n       Average TPS: " + (duration == 0L ? 0L : success * 1000L / duration) + "\n       Average RTT: " + new DecimalFormat("0.00").format(rtt) + "ms\nMax Time Consuming: " + (double)this.maxTimeConsuming / 1000.0 + "ms\nMin Time Consuming: " + (double)this.minTimeConsuming / 1000.0 + "ms\nTest stopped......";
            System.out.println(result);
            this.statistics = true;
        }
    }
}

