/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.feign.config;

import cn.minsin.feign.annotation.EnableFeignExceptionHandler;
import cn.minsin.feign.config.FeignExceptionHandlerContext;
import feign.codec.ErrorDecoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Order(value=88)
public class RegistryFeignExceptionHandler
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(RegistryFeignExceptionHandler.class);

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)annotationMetadata.getAnnotationAttributes(EnableFeignExceptionHandler.class.getName()));
        Class decoderClass = annotationAttributes.getClass("decoderClass");
        ErrorDecoder errorDecoder = (ErrorDecoder)BeanUtils.instantiateClass((Class)decoderClass);
        AbstractBeanDefinition decoder = BeanDefinitionBuilder.genericBeanDefinition(ErrorDecoder.class, () -> errorDecoder).setAutowireMode(2).getBeanDefinition();
        registry.registerBeanDefinition(decoder.getBeanClassName(), (BeanDefinition)decoder);
        Class handlerClass = annotationAttributes.getClass("handlerClass");
        ErrorAttributes errorAttributes = (ErrorAttributes)BeanUtils.instantiateClass((Class)handlerClass);
        AbstractBeanDefinition handler = BeanDefinitionBuilder.genericBeanDefinition(ErrorAttributes.class, () -> errorAttributes).setAutowireMode(2).getBeanDefinition();
        registry.registerBeanDefinition(handler.getBeanClassName(), (BeanDefinition)handler);
        boolean infoEnabled = log.isInfoEnabled();
        if (infoEnabled) {
            log.info("'{}' and '{}' has been successfully registered", (Object)handler.getBeanClassName(), (Object)decoder.getBeanClassName());
        }
    }

    public void setEnvironment(Environment environment) {
        FeignExceptionHandlerContext.setEnvironment(environment);
    }
}

