/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.feign.assert_;

import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Then {
    private static final Logger log = LoggerFactory.getLogger(Then.class);
    private final boolean value;
    private static Class<? extends RuntimeException> defaultException = RuntimeException.class;

    public static void setDefaultException(@NonNull Class<? extends RuntimeException> defaultException) {
        if (defaultException == null) {
            throw new NullPointerException("defaultException is marked non-null but is null");
        }
        try {
            defaultException.getConstructor(String.class);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u5f02\u5e38Class'" + defaultException + "'\u4e2d\u5fc5\u987b\u8981\u6709RuntimeException#Throwable(String)\u6784\u9020\u5668,\u5982\u679c\u662f\u5185\u90e8\u7c7b\u9700\u8981\u58f0\u660e\u4e3apublic static");
        }
        Then.defaultException = defaultException;
    }

    public void withDefaultException(String msg) {
        this.withCustomException(defaultException, msg);
    }

    public void with(Consumer<Boolean> function) {
        function.accept(this.value);
    }

    public void withCustomException(Class<? extends RuntimeException> clazz, String msg) {
        if (this.value) {
            throw Then.createInstance(clazz, msg);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void withRuntimeException(String msg) {
        if (this.value) {
            throw new RuntimeException(msg);
        }
    }

    public void withNullPointException(String msg) {
        if (this.value) {
            throw new NullPointerException(msg);
        }
    }

    public void withFileNotFoundException(String msg) throws FileNotFoundException {
        if (this.value) {
            throw new FileNotFoundException(msg);
        }
    }

    public void withClassNotFoundException(String msg) throws ClassNotFoundException {
        if (this.value) {
            throw new ClassNotFoundException(msg);
        }
    }

    public void withIndexOutOfBoundsException(String msg) {
        if (this.value) {
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public void withArithmeticException(String msg) {
        if (this.value) {
            throw new ArithmeticException(msg);
        }
    }

    public void withException(String msg) throws Exception {
        if (this.value) {
            throw new Exception(msg);
        }
    }

    public void withRuntimeException(RuntimeException exception) {
        if (this.value) {
            throw exception;
        }
    }

    public void withException(Exception exception) throws Exception {
        if (this.value) {
            throw exception;
        }
    }

    public static <T extends RuntimeException> T createInstance(Class<T> clazz, String message) {
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            throw (RuntimeException)constructor.newInstance(message);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error("\u5f02\u5e38Class'{}'\u4e2d\u5fc5\u987b\u8981\u6709RuntimeException#Throwable(String)\u6784\u9020\u5668,\u5982\u679c\u662f\u5185\u90e8\u7c7b\u9700\u8981\u58f0\u660e\u4e3apublic static", clazz);
            throw new RuntimeException(message);
        }
    }

    public Then(boolean value) {
        this.value = value;
    }
}

