/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.feign.exception;

import cn.minsin.feign.config.FeignExceptionHandlerContext;
import cn.minsin.feign.model.ExceptionChain;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RemoteCallException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(RemoteCallException.class);
    private final List<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>(2);
    private boolean isAddThis = false;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private List<ExceptionChain> exceptionChains;

    @Override
    public StackTraceElement[] getStackTrace() {
        if (this.stackTraceElements.isEmpty()) {
            return super.getStackTrace();
        }
        return this.stackTraceElements.toArray(new StackTraceElement[0]);
    }

    public RemoteCallException(String message) {
        super(message);
    }

    public RemoteCallException(String message, Throwable cause) {
        super(message, cause);
    }

    public RemoteCallException(String message, @NonNull List<ExceptionChain> exceptionChains) {
        super(message);
        if (exceptionChains == null) {
            throw new NullPointerException("exceptionChains is marked non-null but is null");
        }
        this.exceptionChains = exceptionChains;
        for (int i = 0; i < exceptionChains.size(); ++i) {
            String status = i == 0 ? "HAPPEN" : "THROW";
            this.create(exceptionChains.get(i), status);
        }
    }

    public String getRawMessage() {
        ExceptionChain rawExceptionInfo = this.getRawExceptionInfo();
        return rawExceptionInfo == null ? null : rawExceptionInfo.getMessage();
    }

    public ExceptionChain getRawExceptionInfo() {
        return CollectionUtils.isEmpty(this.exceptionChains) ? null : this.exceptionChains.get(0);
    }

    public boolean isAssignableFrom(Class<? extends Throwable> exception) {
        ExceptionChain rawExceptionInfo = this.getRawExceptionInfo();
        return rawExceptionInfo != null && rawExceptionInfo.isAssignableFrom(exception);
    }

    @Override
    public String toString() {
        if (!this.isAddThis) {
            this.addThis();
            this.isAddThis = true;
        }
        return super.toString();
    }

    @Override
    public void printStackTrace() {
        if (!this.isAddThis) {
            this.addThis();
            this.isAddThis = true;
        }
        PrintStream err = System.err;
        err.println("cn.minsin.feign.exception.RemoteCallException : " + this.getMessage());
        for (StackTraceElement stackTraceElement : this.stackTraceElements) {
            err.println("\t" + stackTraceElement);
        }
    }

    private void create(ExceptionChain exceptionChain, String status) {
        String format = "[%s]:[%s] timestamp:'%s',exceptionClass:'%s',message:'%s',path: '%s'";
        String str = String.format(format, status, exceptionChain.getApplicationName(), DateFormatUtils.format((Date)exceptionChain.getTimestamp(), (String)DATE_FORMAT), exceptionChain.getExceptionClass(), exceptionChain.getMessage(), exceptionChain.getPath());
        StackTraceElement stackTraceElement = new StackTraceElement(str, "", "", 0);
        this.stackTraceElements.add(stackTraceElement);
    }

    private void addThis() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        String requestPath = "";
        if (requestAttributes instanceof ServletRequestAttributes) {
            requestPath = ((ServletRequestAttributes)requestAttributes).getRequest().getRequestURI();
        }
        ExceptionChain exceptionChain = new ExceptionChain();
        exceptionChain.setApplicationName(FeignExceptionHandlerContext.getApplicationName());
        exceptionChain.setPath(requestPath);
        exceptionChain.setTimestamp(new Date());
        exceptionChain.setExceptionClass("cn.minsin.feign.exception.RemoteCallException");
        exceptionChain.setMessage(this.getMessage());
        this.create(exceptionChain, "END");
    }

    public List<ExceptionChain> getExceptionChains() {
        return this.exceptionChains;
    }
}

