/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.feign.config;

import cn.minsin.feign.config.FeignExceptionDecoder;
import cn.minsin.feign.exception.BaseRemoteCallException;
import cn.minsin.feign.exception.RemoteCallException;
import feign.Contract;
import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.codec.ErrorDecoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Feign.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
public class FeignConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Contract feignContract() {
        return new SpringMvcContract();
    }

    @Bean
    @ConditionalOnMissingBean
    public Request.Options feignOptions() {
        return new Request.Options(10000, 10000);
    }

    @Bean
    @ConditionalOnMissingBean
    public Retryer feignRetry() {
        return Retryer.NEVER_RETRY;
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorDecoder errorDecoder(@Autowired BaseRemoteCallException baseRemoteCallException) {
        return new FeignExceptionDecoder(baseRemoteCallException);
    }

    @Bean
    @ConditionalOnMissingBean
    public BaseRemoteCallException baseRemoteCallException() {
        return new RemoteCallException();
    }
}

