/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.feign.config;

import cn.minsin.feign.exception.RemoteCallException;
import cn.minsin.feign.model.ExceptionChain;
import cn.minsin.feign.util.FeignExceptionHandlerContext;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.web.context.request.WebRequest;

public class FeignExceptionHandler
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(FeignExceptionHandler.class);

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Throwable error = super.getError(webRequest);
        if (error == null) {
            return super.getErrorAttributes(webRequest, includeStackTrace);
        }
        Map errorAttributes = super.getErrorAttributes(webRequest, includeStackTrace);
        ArrayList<ExceptionChain> exceptionChains = null;
        if (error instanceof RemoteCallException) {
            exceptionChains = ((RemoteCallException)error).getExceptionChains();
        } else {
            Object attribute = webRequest.getAttribute("exceptionChain", 0);
            if (attribute != null) {
                exceptionChains = JSON.parseArray((String)attribute.toString(), ExceptionChain.class);
            }
            if (exceptionChains == null) {
                exceptionChains = new ArrayList<ExceptionChain>(1);
            }
        }
        ExceptionChain exceptionChain = new ExceptionChain();
        exceptionChain.setMessage(error.getMessage());
        exceptionChain.setPath(errorAttributes.get("path").toString());
        exceptionChain.setTimestamp(new Date());
        exceptionChain.setApplicationName(FeignExceptionHandlerContext.getApplicationName());
        if (error.getClass() != null) {
            exceptionChain.setExceptionClass(error.getClass().getTypeName());
        }
        exceptionChains.add(exceptionChain);
        errorAttributes.put("exceptionChain", exceptionChains);
        return errorAttributes;
    }
}

