/*
 * Decompiled with CFR 0.152.
 */
package cn.minsin.feign.exception;

import cn.minsin.feign.exception.BaseRemoteCallException;
import cn.minsin.feign.model.ExceptionChain;
import cn.minsin.feign.util.FeignExceptionHandlerContext;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RemoteCallException
extends BaseRemoteCallException {
    private static final Logger log = LoggerFactory.getLogger(RemoteCallException.class);
    private final List<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>(2);
    private boolean isAddThis = false;
    private List<ExceptionChain> exceptionChains;

    @Override
    public StackTraceElement[] getStackTrace() {
        if (this.stackTraceElements.isEmpty()) {
            return super.getStackTrace();
        }
        return this.stackTraceElements.toArray(new StackTraceElement[0]);
    }

    public RemoteCallException() {
    }

    public RemoteCallException(String message) {
        super(message);
    }

    public RemoteCallException(String message, Throwable cause) {
        super(message, cause);
    }

    public RemoteCallException(String message, @NonNull List<ExceptionChain> exceptionChains) {
        super(message);
        if (exceptionChains == null) {
            throw new NullPointerException("exceptionChains is marked non-null but is null");
        }
        this.exceptionChains = exceptionChains;
        for (int i = 0; i < exceptionChains.size(); ++i) {
            String status = i == 0 ? "HAPPEN" : "THROW";
            this.create(exceptionChains.get(i), status);
        }
    }

    public ExceptionChain getRawExceptionInfo() {
        return CollectionUtils.isEmpty(this.exceptionChains) ? null : this.exceptionChains.get(0);
    }

    @Override
    public boolean isInstanceOf(Class<? extends Throwable> exception) {
        ExceptionChain rawExceptionInfo = this.getRawExceptionInfo();
        return rawExceptionInfo != null && rawExceptionInfo.isAssignableFrom(exception);
    }

    @Override
    public String toString() {
        if (!this.isAddThis) {
            this.addThis();
            this.isAddThis = true;
        }
        return super.toString();
    }

    @Override
    public void printStackTrace() {
        if (!this.isAddThis) {
            this.addThis();
            this.isAddThis = true;
        }
        PrintStream err = System.err;
        err.println("cn.minsin.feign.exception.RemoteCallException : " + this.getMessage());
        for (StackTraceElement stackTraceElement : this.stackTraceElements) {
            err.println("\t" + stackTraceElement);
        }
    }

    @Override
    public BaseRemoteCallException throwException(String message) {
        return new RemoteCallException(message);
    }

    @Override
    public BaseRemoteCallException throwException(String message, List<ExceptionChain> exceptionChains) {
        if (exceptionChains == null) {
            return new RemoteCallException(message);
        }
        return new RemoteCallException(message, exceptionChains);
    }

    @Override
    public BaseRemoteCallException throwException(String message, Throwable cause) {
        return new RemoteCallException(message, cause);
    }

    private void create(ExceptionChain exceptionChain, String status) {
        String format = "[%s]:[`http://%s%s`] timestamp:'%s',message:'%s',exceptionClass:'%s',path: '%s'";
        String str = String.format(format, status, exceptionChain.getApplicationName(), exceptionChain.getPath(), DateFormatUtils.format((Date)exceptionChain.getTimestamp(), (String)"yyyy-MM-dd HH:mm:ss.SSS"), exceptionChain.getMessage(), exceptionChain.getExceptionClass(), exceptionChain.getPath());
        StackTraceElement stackTraceElement = new StackTraceElement(str, "", "", 0);
        this.stackTraceElements.add(stackTraceElement);
    }

    private void addThis() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        String requestPath = "";
        if (requestAttributes instanceof ServletRequestAttributes) {
            requestPath = ((ServletRequestAttributes)requestAttributes).getRequest().getRequestURI();
        }
        ExceptionChain exceptionChain = new ExceptionChain();
        exceptionChain.setApplicationName(FeignExceptionHandlerContext.getApplicationName());
        exceptionChain.setPath(requestPath);
        exceptionChain.setTimestamp(new Date());
        exceptionChain.setExceptionClass("cn.minsin.feign.exception.RemoteCallException");
        exceptionChain.setMessage(this.getMessage());
        this.create(exceptionChain, "END");
    }

    public static void main(String[] args) throws ClassNotFoundException {
        Class<?> aClass = Class.forName("java.lang.Exception");
        boolean assignableFrom = RuntimeException.class.isAssignableFrom(aClass);
        System.out.println(assignableFrom);
    }

    public List<ExceptionChain> getExceptionChains() {
        return this.exceptionChains;
    }
}

