/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.union.pay.util;

import cn.minsin.core.init.UnionPayConfig;
import cn.minsin.core.init.core.InitConfig;
import cn.minsin.core.tools.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mutils.union.pay.util.SecureUtil;
import org.mutils.union.pay.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtil {
    private static final UnionPayConfig config = (UnionPayConfig)InitConfig.loadConfig(UnionPayConfig.class);
    private static final Logger logger = LoggerFactory.getLogger(CertUtil.class);
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static PublicKey encryptTrackKey = null;
    private static X509Certificate validateCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();
    private static final ThreadLocal<KeyStore> certKeyStoreLocal = new ThreadLocal();
    private static final Map<String, KeyStore> certKeyStoreMap = new ConcurrentHashMap<String, KeyStore>();

    private static void addProvider() {
        if (Security.getProvider("BC") == null) {
            logger.info("add BC provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            logger.info("re-add BC provider");
        }
        CertUtil.printSysInfo();
    }

    public static void init() {
        CertUtil.addProvider();
        if ("true".equals(config.getSingleMode())) {
            CertUtil.initSignCert();
        }
        CertUtil.initEncryptCert();
        CertUtil.initTrackKey();
        CertUtil.initValidateCertFromDir();
    }

    public static void initSignCert() {
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo(config.getSignCertPath(), config.getSignCertPwd(), config.getSignCertType());
            logger.info("InitSignCert Successful. CertId=[" + CertUtil.getSignCertId() + "]");
        }
        catch (IOException e) {
            logger.error("InitSignCert Error", (Throwable)e);
        }
    }

    public static void initSignCert(String certFilePath, String certPwd) {
        logger.info("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb.");
        certKeyStoreLocal.remove();
        File files = new File(certFilePath);
        if (!files.exists()) {
            logger.info("\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728,\u521d\u59cb\u5316\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25.");
            return;
        }
        try {
            certKeyStoreLocal.set(CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12"));
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        logger.info("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
    }

    public static void loadRsaCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12");
            certKeyStoreMap.put(certFilePath, keyStore);
            logger.info("LoadRsaCert Successful");
        }
        catch (IOException e) {
            logger.error("LoadRsaCert Error", (Throwable)e);
        }
    }

    private static void initEncryptCert() {
        logger.info("\u52a0\u8f7d\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u8bc1\u4e66==>" + config.getEncryptCertPath());
        if (StringUtil.isNotBlank((CharSequence)config.getEncryptCertPath())) {
            encryptCert = CertUtil.initCert(config.getEncryptCertPath());
            logger.info("LoadEncryptCert Successful");
        } else {
            logger.info("WARN: acpsdk.encryptCert.path is empty");
        }
    }

    private static void initTrackKey() {
        if (StringUtil.isNotBlank((CharSequence)config.getEncryptTrackKeyModulus()) && StringUtil.isNotBlank((CharSequence)config.getEncryptTrackKeyExponent())) {
            encryptTrackKey = SecureUtil.getPublicKey(config.getEncryptTrackKeyModulus(), config.getEncryptTrackKeyExponent());
            logger.info("LoadEncryptTrackKey Successful");
        } else {
            logger.info("WARN: acpsdk.encryptTrackKey.modulus or acpsdk.encryptTrackKey.exponent is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            in = new FileInputStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            logger.info("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]");
        }
        catch (CertificateException e) {
            logger.error("InitCert Error", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("InitCert Error File Not Found", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            logger.error("LoadVerifyCert Error No BC Provider", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("initCert\u65b9\u6cd5", (Throwable)e);
                }
            }
        }
        return encryptCertTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        certMap.clear();
        String dir = config.getValidateCertDir();
        logger.info("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u76ee\u5f55==>" + dir);
        if (StringUtil.isBlank((CharSequence)dir)) {
            logger.info("ERROR: acpsdk.validateCert.dir is empty");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            File fileDir = new File(dir);
            File[] files = fileDir.listFiles(new CerFilter());
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                logger.info("[" + file.getAbsolutePath() + "][CertId=" + validateCert.getSerialNumber().toString() + "]");
            }
            logger.info("LoadVerifyCert Successful");
        }
        catch (CertificateException e) {
            logger.error("LoadVerifyCert Error", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error("LoadVerifyCert Error File Not Found", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            logger.error("LoadVerifyCert Error No BC Provider", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("initValidateCertFromDir\u65b9\u6cd5", (Throwable)e);
                }
            }
        }
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, config.getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            logger.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            logger.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByThreadLocal(String certPath, String certPwd) {
        if (null == certKeyStoreLocal.get()) {
            CertUtil.initSignCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = certKeyStoreLocal.get().aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)certKeyStoreLocal.get().getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6[" + certPath + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!certKeyStoreMap.containsKey(certPath)) {
            CertUtil.loadRsaCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = certKeyStoreMap.get(certPath).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)certKeyStoreMap.get(certPath).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            logger.error("getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            logger.error("getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        if (null == encryptCert) {
            String path = config.getEncryptCertPath();
            if (StringUtil.isNotBlank((CharSequence)path)) {
                encryptCert = CertUtil.initCert(path);
                return encryptCert.getPublicKey();
            }
            logger.info("ERROR: acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getPublicKey();
    }

    public static PublicKey getEncryptTrackPublicKey() {
        if (null == encryptTrackKey) {
            CertUtil.initTrackKey();
        }
        return encryptTrackKey;
    }

    public static PublicKey getValidateKey() {
        if (null == validateCert) {
            return null;
        }
        return validateCert.getPublicKey();
    }

    public static PublicKey getValidateKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        logger.info("\u7f3a\u5c11certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66.");
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            logger.error("getSignCertId Error", (Throwable)e);
            return null;
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            String path = config.getEncryptCertPath();
            if (StringUtil.isNotBlank((CharSequence)path)) {
                encryptCert = CertUtil.initCert(path);
                return encryptCert.getSerialNumber().toString();
            }
            logger.info("ERROR: acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getSerialNumber().toString();
    }

    public static PublicKey getSignPublicKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            Certificate cert = keyStore.getCertificate(keyAlias);
            PublicKey pubkey = cert.getPublicKey();
            return pubkey;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u516c\u94a5\u5bf9\u8c61", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        logger.info("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile);
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance(type, "BC");
            logger.info("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]");
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            if (Security.getProvider("BC") == null) {
                logger.info("BC Provider not installed.");
            }
            logger.error("getKeyInfo Error", (Throwable)e);
            if (e instanceof KeyStoreException && "PKCS12".equals(type)) {
                Security.removeProvider("BC");
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static void printSysInfo() {
        logger.info("================= SYS INFO begin====================");
        logger.info("os_name:" + System.getProperty("os.name"));
        logger.info("os_arch:" + System.getProperty("os.arch"));
        logger.info("os_version:" + System.getProperty("os.version"));
        logger.info("java_vm_specification_version:" + System.getProperty("java.vm.specification.version"));
        logger.info("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor"));
        logger.info("java_vm_specification_name:" + System.getProperty("java.vm.specification.name"));
        logger.info("java_vm_version:" + System.getProperty("java.vm.version"));
        logger.info("java_vm_name:" + System.getProperty("java.vm.name"));
        logger.info("java.version:" + System.getProperty("java.version"));
        logger.info("java.vm.vendor=[" + System.getProperty("java.vm.vendor") + "]");
        logger.info("java.version=[" + System.getProperty("java.version") + "]");
        CertUtil.printProviders();
        logger.info("================= SYS INFO end=====================");
    }

    public static void printProviders() {
        logger.info("Providers List:");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            logger.info(i + 1 + "." + providers[i].getName());
        }
    }

    public static String getCertIdByThreadLocal(String certPath, String certPwd) {
        CertUtil.initSignCert(certPath, certPwd);
        try {
            Enumeration<String> aliasenum = certKeyStoreLocal.get().aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)certKeyStoreLocal.get().getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public static String getCertIdByKeyStoreMap(String certPath, String certPwd) {
        if (!certKeyStoreMap.containsKey(certPath)) {
            CertUtil.loadRsaCert(certPath, certPwd);
        }
        return CertUtil.getCertIdIdByStore(certKeyStoreMap.get(certPath));
    }

    private static String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            logger.error("getCertIdIdByStore Error", (Throwable)e);
            return null;
        }
    }

    public static Map<String, X509Certificate> getCertMap() {
        return certMap;
    }

    public static void setCertMap(Map<String, X509Certificate> certMap) {
        CertUtil.certMap = certMap;
    }

    public static PublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            logger.error("\u6784\u9020RSA\u516c\u94a5\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static PublicKey getEncryptTrackCertPublicKey(String modulus, String exponent) {
        if (SignUtil.isEmpty(modulus) || SignUtil.isEmpty(exponent)) {
            logger.info("\u4f7f\u7528\u6a21\u548c\u6307\u6570\u7684\u65b9\u5f0f\u83b7\u53d6\u516c\u94a5\u5bf9\u8c61[modulus] OR [exponent] invalid");
            return null;
        }
        return CertUtil.getPublicKey(modulus, exponent);
    }

    static {
        CertUtil.init();
    }

    static class CerFilter
    implements FilenameFilter {
        CerFilter() {
        }

        public boolean isCer(String name) {
            return name.toLowerCase().endsWith(".cer");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.isCer(name);
        }
    }
}

