/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.union.pay.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mutils.union.pay.util.CertUtil;
import org.mutils.union.pay.util.HttpClient;
import org.mutils.union.pay.util.SecureUtil;
import org.mutils.union.pay.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcpService {
    private static final Logger logger = LoggerFactory.getLogger(AcpService.class);

    public static Map<String, String> sign(Map<String, String> reqData) {
        Map<String, String> submitData = SignUtil.filterBlank(reqData);
        SignUtil.sign(submitData, "UTF-8");
        return submitData;
    }

    public static Map<String, String> sign(Map<String, String> reqData, String certPath, String certPwd, String encoding) {
        Map<String, String> submitData = SignUtil.filterBlank(reqData);
        SignUtil.signByCertInfo(submitData, certPath, certPwd, encoding);
        return submitData;
    }

    public static boolean validate(Map<String, String> rspData, String encoding) {
        logger.info("\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb");
        if (SignUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        String stringSign = rspData.get("signature");
        String certId = rspData.get("certId");
        logger.info("\u5bf9\u8fd4\u56de\u62a5\u6587\u4e32\u9a8c\u7b7e\u4f7f\u7528\u7684\u9a8c\u7b7e\u516c\u94a5\u5e8f\u5217\u53f7\uff1a[" + certId + "]");
        String stringData = SignUtil.coverMap2String(rspData);
        logger.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
        try {
            return SecureUtil.validateSignBySoft(CertUtil.getValidateKey(certId), SecureUtil.base64Decode(stringSign.getBytes(encoding)), SecureUtil.sha1X16(stringData, encoding));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean validateAppResponse(String jsonData, String encoding) {
        Pattern p;
        Matcher m;
        logger.info("\u63a7\u4ef6\u5e94\u7b54\u4fe1\u606f\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb\uff1a[" + jsonData + "]");
        if (SignUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if (!(m = (p = Pattern.compile("\\s*\"sign\"\\s*:\\s*\"([^\"]*)\"\\s*")).matcher(jsonData)).find()) {
            return false;
        }
        String sign = m.group(1);
        p = Pattern.compile("\\s*\"data\"\\s*:\\s*\"([^\"]*)\"\\s*");
        m = p.matcher(jsonData);
        if (!m.find()) {
            return false;
        }
        String data = m.group(1);
        p = Pattern.compile("cert_id=(\\d*)");
        m = p.matcher(jsonData);
        if (!m.find()) {
            return false;
        }
        String certId = m.group(1);
        try {
            return SecureUtil.validateSignBySoft(CertUtil.getValidateKey(certId), SecureUtil.base64Decode(sign.getBytes(encoding)), SecureUtil.sha1X16(data, encoding));
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static Map<String, String> post(Map<String, String> reqData, String reqUrl, String encoding) {
        HashMap<String, String> rspData = new HashMap<String, String>();
        logger.info("\u8bf7\u6c42\u94f6\u8054\u5730\u5740:" + reqUrl);
        HttpClient hc = new HttpClient(reqUrl, 30000, 30000);
        try {
            int status = hc.send(reqData, encoding);
            if (200 == status) {
                String resultString = hc.getResult();
                if (null != resultString && !"".equals(resultString)) {
                    Map<String, String> tmpRspData = SignUtil.convertResultStringToMap(resultString);
                    rspData.putAll(tmpRspData);
                }
            } else {
                logger.info("\u8fd4\u56dehttp\u72b6\u6001\u7801[" + status + "]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u62a5\u6587\u6216\u8005\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return rspData;
    }

    public static String get(String reqUrl, String encoding) {
        logger.info("\u8bf7\u6c42\u94f6\u8054\u5730\u5740:" + reqUrl);
        HttpClient hc = new HttpClient(reqUrl, 30000, 30000);
        try {
            int status = hc.sendGet(encoding);
            if (200 == status) {
                String resultString = hc.getResult();
                if (null != resultString && !"".equals(resultString)) {
                    return resultString;
                }
            } else {
                logger.info("\u8fd4\u56dehttp\u72b6\u6001\u7801[" + status + "]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u62a5\u6587\u6216\u8005\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String createAutoFormHtml(String reqUrl, Map<String, String> hiddens) {
        StringBuffer sf = new StringBuffer();
        sf.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/></head><body>");
        sf.append("<form id = \"pay_form\" action=\"" + reqUrl + "\" method=\"post\">");
        if (null != hiddens && 0 != hiddens.size()) {
            Set<Map.Entry<String, String>> set = hiddens.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.pay_form.submit();");
        sf.append("</script>");
        sf.append("</html>");
        return sf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String enCodeFileContent(String filePath, String encoding) {
        String baseFileContent = "";
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int fl = ((InputStream)in).available();
            if (null != in) {
                byte[] s = new byte[fl];
                ((InputStream)in).read(s, 0, fl);
                baseFileContent = new String(SecureUtil.base64Encode(SecureUtil.deflater(s)), encoding);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return baseFileContent;
    }

    public static String deCodeFileContent(Map<String, String> resData, String fileDirectory, String encoding) {
        String fileContent = resData.get("fileContent");
        String filePath = null;
        if (null != fileContent && !"".equals(fileContent)) {
            try {
                byte[] fileArray = SecureUtil.inflater(SecureUtil.base64Decode(fileContent.getBytes(encoding)));
                filePath = SignUtil.isEmpty(resData.get("fileName")) ? fileDirectory + File.separator + resData.get("merId") + "_" + resData.get("batchNo") + "_" + resData.get("txnTime") + ".txt" : fileDirectory + File.separator + resData.get("fileName");
                File file = new File(filePath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                out.write(fileArray, 0, fileArray.length);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return filePath;
    }

    public static String getFileContent(String fileContent, String encoding) {
        String fc = "";
        try {
            fc = new String(SecureUtil.inflater(SecureUtil.base64Decode(fileContent.getBytes())), encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return fc;
    }

    public static String getCustomerInfo(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        Iterator<String> it = customerInfoMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = customerInfoMap.get(key);
            if (key.equals("pin")) {
                if (null == accNo || "".equals(accNo.trim())) {
                    logger.info("\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfo\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin(accNo, value, encoding);
            }
            sf.append(key).append("=").append(value);
            if (!it.hasNext()) continue;
            sf.append("&");
        }
        String customerInfo = sf.append("}").toString();
        logger.info("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo);
        try {
            return new String(SecureUtil.base64Encode(sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return customerInfo;
    }

    public static String getCustomerInfoWithEncrypt(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        StringBuffer encryptedInfoSb = new StringBuffer("");
        for (String key : customerInfoMap.keySet()) {
            String value = customerInfoMap.get(key);
            if (key.equals("phoneNo") || key.equals("cvn2") || key.equals("expired")) {
                encryptedInfoSb.append(key).append("=").append(value).append("&");
                continue;
            }
            if (key.equals("pin")) {
                if (null == accNo || "".equals(accNo.trim())) {
                    logger.info("\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfoWithEncrypt\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin(accNo, value, encoding);
            }
            sf.append(key).append("=").append(value).append("&");
        }
        if (!encryptedInfoSb.toString().equals("")) {
            encryptedInfoSb.setLength(encryptedInfoSb.length() - 1);
            logger.info("\u7ec4\u88c5\u7684customerInfo encryptedInfo\u660e\u6587\uff1a" + encryptedInfoSb.toString());
            sf.append("encryptedInfo").append("=").append(AcpService.encryptData(encryptedInfoSb.toString(), encoding));
        } else {
            sf.setLength(sf.length() - 1);
        }
        String customerInfo = sf.append("}").toString();
        logger.info("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo);
        try {
            return new String(SecureUtil.base64Encode(sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return customerInfo;
    }

    public static Map<String, String> parseCustomerInfo(String customerInfo, String encoding) {
        Map<String, String> customerInfoMap = null;
        try {
            byte[] b = SecureUtil.base64Decode(customerInfo.getBytes(encoding));
            String customerInfoNoBase64 = new String(b, encoding);
            logger.info("\u89e3base64\u540e===>" + customerInfoNoBase64);
            customerInfoNoBase64 = customerInfoNoBase64.substring(1, customerInfoNoBase64.length() - 1);
            customerInfoMap = SignUtil.parseQString(customerInfoNoBase64);
            if (customerInfoMap.containsKey("encryptedInfo")) {
                String encInfoStr = customerInfoMap.get("encryptedInfo");
                customerInfoMap.remove("encryptedInfo");
                String encryptedInfoStr = AcpService.decryptData(encInfoStr, encoding);
                Map<String, String> encryptedInfoMap = SignUtil.parseQString(encryptedInfoStr);
                customerInfoMap.putAll(encryptedInfoMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return customerInfoMap;
    }

    public static String encryptPin(String accNo, String pwd, String encoding) {
        return SecureUtil.EncryptPin(pwd, accNo, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String encryptData(String data, String encoding) {
        return SecureUtil.EncryptData(data, encoding, CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptData(String base64EncryptedInfo, String encoding) {
        return SecureUtil.DecryptedData(base64EncryptedInfo, encoding, CertUtil.getSignCertPrivateKey());
    }

    public static String encryptTrack(String trackData, String encoding) {
        return SecureUtil.EncryptData(trackData, encoding, CertUtil.getEncryptTrackPublicKey());
    }

    public static String encryptTrack(String trackData, String encoding, String modulus, String exponent) {
        return SecureUtil.EncryptData(trackData, encoding, CertUtil.getEncryptTrackCertPublicKey(modulus, exponent));
    }

    public static String getEncryptCertId() {
        return CertUtil.getEncryptCertId();
    }

    public static String base64Encode(String rawStr, String encoding) throws IOException {
        byte[] rawByte = rawStr.getBytes(encoding);
        return new String(SecureUtil.base64Encode(rawByte), encoding);
    }

    public static String base64Decode(String base64Str, String encoding) throws IOException {
        byte[] rawByte = base64Str.getBytes(encoding);
        return new String(SecureUtil.base64Decode(rawByte), encoding);
    }
}

