/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.union.pay.util;

import cn.minsin.core.tools.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mutils.union.pay.util.CertUtil;
import org.mutils.union.pay.util.SecureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger logger = LoggerFactory.getLogger(SignUtil.class);

    public static boolean sign(Map<String, String> data, String encoding) {
        if (SignUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        data.put("certId", CertUtil.getSignCertId());
        String stringData = SignUtil.coverMap2String(data);
        logger.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
        byte[] byteSign = null;
        String stringSign = null;
        try {
            byte[] signDigest = SecureUtil.sha1X16(stringData, encoding);
            byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft(CertUtil.getSignCertPrivateKey(), signDigest));
            stringSign = new String(byteSign);
            data.put("signature", stringSign);
            return true;
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public static boolean signByCertInfo(Map<String, String> data, String certPath, String certPwd, String encoding) {
        if (SignUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if (SignUtil.isEmpty(certPath) || SignUtil.isEmpty(certPwd)) {
            logger.info("Invalid Parameter:CertPath=[" + certPath + "],CertPwd=[" + certPwd + "]");
            return false;
        }
        data.put("certId", CertUtil.getCertIdByKeyStoreMap(certPath, certPwd));
        String stringData = SignUtil.coverMap2String(data);
        byte[] byteSign = null;
        String stringSign = null;
        try {
            byte[] signDigest = SecureUtil.sha1X16(stringData, encoding);
            byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft(CertUtil.getSignCertPrivateKeyByStoreMap(certPath, certPwd), signDigest));
            stringSign = new String(byteSign);
            data.put("signature", stringSign);
            return true;
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public static String coverMap2String(Map<String, String> data) {
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Map.Entry<String, String> en : data.entrySet()) {
            if ("signature".equals(en.getKey().trim())) continue;
            tree.put(en.getKey(), en.getValue());
        }
        Iterator<Map.Entry<String, String>> it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            sf.append(en.getKey() + "=" + en.getValue() + "&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    public static Map<String, String> coverResultString2Map(String result) {
        return SignUtil.convertResultStringToMap(result);
    }

    public static Map<String, String> convertResultStringToMap(String result) {
        Map<String, String> map = null;
        try {
            if (StringUtil.isNotBlank((CharSequence)result)) {
                if (result.startsWith("{") && result.endsWith("}")) {
                    System.out.println(result.length());
                    result = result.substring(1, result.length() - 1);
                }
                map = SignUtil.parseQString(result);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static Map<String, String> parseQString(String str) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        int len = str.length();
        StringBuilder temp = new StringBuilder();
        String key = null;
        boolean isKey = true;
        boolean isOpen = false;
        char openName = '\u0000';
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char curChar = str.charAt(i);
                if (isKey) {
                    if (curChar == '=') {
                        key = temp.toString();
                        temp.setLength(0);
                        isKey = false;
                        continue;
                    }
                    temp.append(curChar);
                    continue;
                }
                if (isOpen) {
                    if (curChar == openName) {
                        isOpen = false;
                    }
                } else {
                    if (curChar == '{') {
                        isOpen = true;
                        openName = '}';
                    }
                    if (curChar == '[') {
                        isOpen = true;
                        openName = ']';
                    }
                }
                if (curChar == '&' && !isOpen) {
                    SignUtil.putKeyValueToMap(temp, isKey, key, map);
                    temp.setLength(0);
                    isKey = true;
                    continue;
                }
                temp.append(curChar);
            }
            SignUtil.putKeyValueToMap(temp, isKey, key, map);
        }
        return map;
    }

    private static void putKeyValueToMap(StringBuilder temp, boolean isKey, String key, Map<String, String> map) throws UnsupportedEncodingException {
        if (isKey) {
            key = temp.toString();
            if (key.length() == 0) {
                throw new RuntimeException("QString format illegal");
            }
            map.put(key, "");
        } else {
            if (key.length() == 0) {
                throw new RuntimeException("QString format illegal");
            }
            map.put(key, temp.toString());
        }
    }

    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }

    public static Map<String, String> filterBlank(Map<String, String> contentData) {
        logger.info("\u6253\u5370\u8bf7\u6c42\u62a5\u6587\u57df :");
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        Set<String> keyset = contentData.keySet();
        for (String key : keyset) {
            String value = contentData.get(key);
            if (!StringUtil.isNotBlank((CharSequence)value)) continue;
            submitFromData.put(key, value.trim());
            logger.info(key + "-->" + String.valueOf(value));
        }
        return submitFromData;
    }
}

