/*
 * Decompiled with CFR 0.152.
 */
package org.mutils.union.pay;

import cn.minsin.core.exception.MutilsErrorException;
import cn.minsin.core.exception.MutilsException;
import cn.minsin.core.init.UnionPayConfig;
import cn.minsin.core.init.core.AbstractConfig;
import cn.minsin.core.rule.AbstractFunctionRule;
import cn.minsin.core.tools.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import org.mutils.union.pay.model.UnionPayModel;
import org.mutils.union.pay.util.AcpService;

public class UnionPayFunctions
extends AbstractFunctionRule {
    private static final UnionPayConfig config = (UnionPayConfig)AbstractConfig.loadConfig(UnionPayConfig.class);

    public static String unionPay(UnionPayModel model) throws MutilsErrorException {
        SortedMap<String, String> requestData = model.toTreeMap();
        Map<String, String> submitFromData = AcpService.sign(requestData);
        String requestFrontUrl = config.getFrontRequestUrl();
        String form = AcpService.createAutoFormHtml(requestFrontUrl, submitFromData);
        LOGGER.info("\u6253\u5370\u8bf7\u6c42HTML\uff0c\u6b64\u4e3a\u8bf7\u6c42\u62a5\u6587\uff0c\u4e3a\u8054\u8c03\u6392\u67e5\u95ee\u9898\u7684\u4f9d\u636e\uff1a{}", (Object)form);
        return form;
    }

    public static Map<String, String> parseNotify(HttpServletRequest request) throws MutilsErrorException {
        String encoding = request.getParameter("encoding");
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                String string = (String)res.get(en);
                if (!StringUtil.isNotBlank((CharSequence)string)) continue;
                res.put(en, value);
            }
        }
        HashMap<String, String> valideData = null;
        if (null != res && !res.isEmpty()) {
            Iterator it = res.entrySet().iterator();
            valideData = new HashMap<String, String>(res.size());
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                try {
                    value = new String(value.getBytes(encoding), encoding);
                }
                catch (UnsupportedEncodingException e1) {
                    throw new MutilsException((Throwable)e1, key + " Conversion to " + encoding + " failed.");
                }
                valideData.put(key, value);
            }
        }
        if (AcpService.validate(valideData, encoding)) {
            return valideData;
        }
        throw new MutilsErrorException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
    }
}

