package cn.miw.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

/**
 * 大文本文件读取工具(线程+缓冲区读取+回调处理)
 * 
 * @author mrzhou
 *
 */
public class BigTextFileProcess {

	public static void main(String[] args) throws IOException, InterruptedException {
		System.out.println(Arrays.toString(args));
		if (args.length > 0 && args[0] != null)
			new BigTextFileProcess().readBigFile((fileName,line) -> { System.out.println(fileName+":"+line); }, args);
		Thread.sleep(5000);
	}

	/**
	 * 同时读取多个文件
	 * @param lineHandler 行处理器
	 * @param fileNames	多个文件数组
	 */
	public void readBigFile(IProcessLineHandler lineHandler, String... fileNames) {
		for (String name : fileNames) {
			readBigFile(name, lineHandler);
		}
	}
	/**
	 * 读大文本文件
	 * 
	 * @author mrzhou@miw.cn
	 * @param fileName    文件名
	 * @param lineHandler 行处理器
	 */
	public void readBigFile(String fileName,IProcessLineHandler lineHandler) {
		new Thread(() -> {
			try {
				FileInputStream inputStream = new FileInputStream(fileName);
				InputStreamReader streamReader = new InputStreamReader(inputStream);
				BufferedReader reader = new BufferedReader(streamReader);

				String line = reader.readLine();
				while (line != null && lineHandler != null) {
					lineHandler.process(fileName,line);
					line = reader.readLine();
				}
				reader.close();
				inputStream.close();
			} catch (IOException e) {
				System.err.println("文件操作错误:" + e.getMessage());
			}
		}).start();
	}

	/**
	 * 行处理器
	 * 
	 * @author mrzhou@miw.cn
	 *
	 */
	public interface IProcessLineHandler {
		void process(String fileName,String line);
	}

}
