/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class BigTextFileProcess {
    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.println(Arrays.toString(args));
        if (args.length > 0 && args[0] != null) {
            new BigTextFileProcess().readBigFile((String fileName, String line) -> System.out.println(fileName + ":" + line), args);
        }
        Thread.sleep(5000L);
    }

    public void readBigFile(IProcessLineHandler lineHandler, String ... fileNames) {
        for (String name : fileNames) {
            this.readBigFile(name, lineHandler);
        }
    }

    public void readBigFile(String fileName, IProcessLineHandler lineHandler) {
        new Thread(() -> {
            try {
                FileInputStream inputStream = new FileInputStream(fileName);
                InputStreamReader streamReader = new InputStreamReader(inputStream);
                BufferedReader reader = new BufferedReader(streamReader);
                String line = reader.readLine();
                while (line != null && lineHandler != null) {
                    lineHandler.process(fileName, line);
                    line = reader.readLine();
                }
                reader.close();
                inputStream.close();
            }
            catch (IOException e) {
                System.err.println("\u6587\u4ef6\u64cd\u4f5c\u9519\u8bef:" + e.getMessage());
            }
        }).start();
    }

    public static interface IProcessLineHandler {
        public void process(String var1, String var2);
    }
}

