package cn.miw.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

/**
 * 大文本文件读取工具(线程+缓冲区读取+回调处理)
 * 
 * @author mrzhou@miw.cn
 *
 */
public class BigTextFileProcess {

	public static void main(String[] fileNames) throws IOException, InterruptedException {
		System.out.println(Arrays.toString(fileNames));
		if (fileNames.length > 0 && fileNames[0] != null)
			new BigTextFileProcess().readBigFile((fileName, line) -> {
				System.out.println(fileName + ":" + line);
			}, fileNames);
		Thread.sleep(5000);
//		new BigTextFileProcess().readBigFile("/Users/mrzhou/Library/Containers/com.youku.mac/Data/Playlog/com.youku.mac 2019-04-05--12-08-58-795.log",
//				(name, line) -> {
//					System.out.println(line);
//				});
	}

	/**
	 * 同时读取多个文件
	 * 
	 * @author mrzhou@miw.cn
	 * @param lineHandler 行处理器
	 * @param fileNames   多个文件数组
	 */
	public void readBigFile(IProcessLineHandler lineHandler, String... fileNames) {
		for (String name : fileNames) {
			readBigFile(name, lineHandler);
		}
	}

	/**
	 * 读大文本文件
	 * 
	 * @author mrzhou@miw.cn
	 * @param fileName    文件名
	 * @param lineHandler 行处理器
	 */
	public void readBigFile(String fileName, IProcessLineHandler lineHandler) {
		new Thread(() -> {
			FileInputStream inputStream = null;
			BufferedReader reader = null;
			try {
				inputStream = new FileInputStream(fileName);
				BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
				InputStreamReader streamReader = new InputStreamReader(bufferedInputStream);
				reader = new BufferedReader(streamReader, 10 * 1024 * 1024);

				String line = reader.readLine();
				while (line != null && lineHandler != null) {
					lineHandler.process(fileName, line);
					line = reader.readLine();
				}
			} catch (IOException e) {
				System.err.println("文件操作错误:" + fileName + "\t" + e.getMessage());
			} finally {
				try {
					if (reader != null) reader.close();
					if (inputStream != null) inputStream.close();
				} catch (IOException e) {
				}
			}
		}).start();
	}

	/**
	 * 行处理器
	 * 
	 * @author mrzhou@miw.cn
	 *
	 */
	public interface IProcessLineHandler {
		void process(String fileName, String line);
	}

}
