/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class BigTextFileProcess {
    public static void main(String[] fileNames) throws IOException, InterruptedException {
        System.out.println(Arrays.toString(fileNames));
        if (fileNames.length > 0 && fileNames[0] != null) {
            new BigTextFileProcess().readBigFile((String fileName, String line) -> System.out.println(fileName + ":" + line), fileNames);
        }
        Thread.sleep(5000L);
    }

    public void readBigFile(IProcessLineHandler lineHandler, String ... fileNames) {
        for (String name : fileNames) {
            this.readBigFile(name, lineHandler);
        }
    }

    public void readBigFile(String fileName, IProcessLineHandler lineHandler) {
        new Thread(() -> {
            FileInputStream inputStream = null;
            BufferedReader reader = null;
            try {
                inputStream = new FileInputStream(fileName);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                InputStreamReader streamReader = new InputStreamReader(bufferedInputStream);
                reader = new BufferedReader(streamReader, 0xA00000);
                String line = reader.readLine();
                while (line != null && lineHandler != null) {
                    lineHandler.process(fileName, line);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                System.err.println("\u6587\u4ef6\u64cd\u4f5c\u9519\u8bef:" + fileName + "\t" + e.getMessage());
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }).start();
    }

    public static interface IProcessLineHandler {
        public void process(String var1, String var2);
    }
}

