/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.simple;

import cn.miw.simple.annotations.Mapping;
import cn.miw.simple.beans.MappingDefine;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleWeb
implements Filter {
    private String packageName;
    private CharSequence contextPath;
    List<String> clsNames = new ArrayList<String>();
    Map<String, MappingDefine> mappinfos = new HashMap<String, MappingDefine>();

    public void init(FilterConfig config) throws ServletException {
        this.packageName = config.getInitParameter("scanPackage");
        if (this.packageName == null || "".equals(this.packageName)) {
            this.packageName = this.getClass().getPackage().getName();
        }
        ServletContext context = config.getServletContext();
        this.contextPath = context.getContextPath();
        this.init();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String mappinfo = req.getRequestURI().replace(this.contextPath, "");
        MappingDefine define = this.mappinfos.get(mappinfo);
        if (define == null) {
            resp.setCharacterEncoding("utf-8");
            resp.setContentType("text/html;charset:utf-8");
            resp.getWriter().append("\u529f\u80fd\u8fd8\u5728\u5f00\u53d1\u4e2d");
            return;
        }
        this.exec(mappinfo, define, req, resp);
        chain.doFilter(request, response);
    }

    private Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
        Object instance = define.getInstance();
        Method method = define.getMethod();
        Object result = null;
        try {
            Parameter[] types = method.getParameters();
            System.out.println(types.length);
            if (types.length == 0) {
                result = method.invoke(instance, new Object[0]);
            } else {
                Object[] args = this.prepare(types, req, resp);
                result = method.invoke(instance, args);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Object[] prepare(Parameter[] params, HttpServletRequest req, HttpServletResponse resp) {
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            String v = req.getParameter(params[i].getName());
            result[i] = this.parse(v, params[i].getType(), req, resp);
        }
        return result;
    }

    private <T> Object parse(String v, Class<T> type, HttpServletRequest req, HttpServletResponse resp) {
        if (type.getClassLoader() != null) {
            return v;
        }
        if (v == null) {
            return null;
        }
        String name = type.getSimpleName().toLowerCase();
        if ("byte".equals(name) || "short".equals(name) || "int".equals(name) || "integer".equals(name)) {
            return Integer.parseInt(v);
        }
        if ("long".equals(name)) {
            return Long.parseLong(v);
        }
        if ("float".equals(name)) {
            return Float.valueOf(Float.parseFloat(v));
        }
        if ("double".equals(name)) {
            return Double.parseDouble(v);
        }
        if ("boolean".equals(name)) {
            return v != null;
        }
        if ("httpservletrequest".equals(name)) {
            return req;
        }
        if ("httpservletresponse".equals(name)) {
            return resp;
        }
        if ("httpsession".equals(name)) {
            return req.getSession();
        }
        return v;
    }

    private void init() {
        this.scanPackage(this.packageName);
        this.findMapping();
    }

    private void findMapping() {
        this.clsNames.forEach(className -> {
            try {
                Class<?> clz = Class.forName(className);
                Mapping mapping = clz.getAnnotation(Mapping.class);
                if (mapping != null) {
                    Method[] methods;
                    String path = mapping.value();
                    path = "".equals(path) ? "/" : path;
                    path = path.startsWith("/") ? path : "/" + path;
                    Object instance = clz.newInstance();
                    for (Method method : methods = clz.getDeclaredMethods()) {
                        Mapping mapp = method.getAnnotation(Mapping.class);
                        if (mapp == null) continue;
                        String pathm = mapp.value();
                        pathm = "".equals(pathm) ? "/" : pathm;
                        pathm = pathm.startsWith("/") ? pathm : "/" + pathm;
                        String mappinfo = (path + pathm).replaceAll("//", "/");
                        this.mappinfos.put(mappinfo, new MappingDefine(instance, method));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void scanPackage(String name) {
        URL url = this.getClass().getClassLoader().getResource(name.replaceAll("\\.", "/"));
        new File(url.getFile()).listFiles(child -> {
            if (child.isDirectory()) {
                this.scanPackage(name + "." + child.getName());
            } else if (child.getName().endsWith(".class")) {
                this.clsNames.add(name + "." + child.getName().replaceAll("\\.class", ""));
            }
            return false;
        });
    }
}

