package cn.miw.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jfinal.template.Engine;

import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.utils.SWUtil;

public class SimpleWeb {

	private List<String> clsNames = new ArrayList<String>();
	private Map<String, MappingDefine> mappinfos = new ConcurrentHashMap<String, MappingDefine>(16);
	private ServletContext context;

	private SimpleWeb() {
	}

	public static SimpleWeb me() {
		return SimpleWebInstance.instance;
	}

	private static class SimpleWebInstance {
		public final static SimpleWeb instance = new SimpleWeb();
	}

	public void init(ServletContext context, String packageName) throws ServletException {
		this.context = context;
		setRootPath("/", false);
		clsNames.addAll(SWUtil.scanPackage(packageName, getClass().getName()));
		SWUtil.findMapping(clsNames, mappinfos);
	}

	public void setRootPath(String path, boolean abs) {
		Engine engine = Engine.use();
		engine.setBaseTemplatePath(abs ? path : context.getRealPath(("/" + path).replaceAll("/+", "/")));
	}

	public MappingDefine findMapping(String mappinfo) {
		return mappinfos.get(mappinfo);
	}

	public Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
		return SWUtil.exec(mappinfo, define, req, resp);
	}

	public void destroy() {
		mappinfos.forEach((key, define) -> {
			define.clear();
		});
		mappinfos.clear();
		mappinfos = null;
		clsNames.clear();
		clsNames = null;
	}
}
