package cn.miw.simple.aop;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import cn.miw.simple.aop.SimpleFactory.ISimpleHandler;
import net.sf.cglib.proxy.MethodProxy;

public abstract class SimpleHandler implements ISimpleHandler {
	private Object target;

	public SimpleHandler(Object target) {
		this.target = target;
	}
	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		return exec(proxy, method, args);
	}
	@Override
	public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
		return exec(proxy, method, args);
	}
	
	private Object exec(Object proxy, Method method, Object[] args)
			throws IllegalAccessException, InvocationTargetException {
		before(proxy,method,args);
		Object result = method.invoke(target, args);
		after(proxy,method,args,result);
		return result;
	}
}
