package cn.miw.simple.utils;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.miw.simple.annotations.Mapping;
import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.beans.ModelAndView;

public class SWUtil {
	public static ClassLoader getClassLoader() {
		return Thread.currentThread().getContextClassLoader();
	}

	public static List<String> scanPackage(String name, String exclude) {
		List<String> result = new ArrayList<>();
		URL url = getClassLoader().getResource(name.replaceAll("\\.", "/"));
		new File(url.getFile()).listFiles(child -> {
			if (child.isDirectory()) {
				result.addAll(scanPackage(name + "." + child.getName(), exclude));
			} else if (child.getName().endsWith(".class")) {
				String clsName = name + "." + child.getName().replaceAll("\\.class", "");
				if (!clsName.equals(exclude)) {
					result.add(clsName);
				}
			}
			return false;
		});
		return result;
	}

	public static void findMapping(List<String> clsNames, Map<String, MappingDefine> mappinfos)
			throws ServletException {
		for (String className : clsNames) {
			try {
				Class<?> clz = Class.forName(className);
				Mapping mapping = clz.getAnnotation(Mapping.class);
				if (mapping != null) {
					String path = mapping.value();
					path = "".equals(path) ? "/" : path;
					path = path.startsWith("/") ? path : "/" + path;
					Object instance = clz.newInstance();
					Method[] methods = clz.getDeclaredMethods();
					for (Method method : methods) {
						String pathm = "/" + method.getName();
						Mapping mapp = method.getAnnotation(Mapping.class);
						if (mapp != null) {
							String temp = mapp.value();
							pathm = "".equals(temp) ? pathm : temp;
						}
						pathm = pathm.startsWith("/") ? pathm : "/" + pathm;
						String mappinfo = (path + pathm).replaceAll("/+", "/");
						if (mappinfos.containsKey(mappinfo)) {
							StringBuffer msg = new StringBuffer();
							msg.append("\n========================================================================\n");
							msg.append("重复定义:\t" + mappinfo + "\n");
							msg.append("在类:\t" + clz.getName() + ".java\n");
							msg.append("方法:\t" + method.getName());
							MappingDefine define = mappinfos.get(mappinfo);
							msg.append("\n========================================================================\n");
							msg.append("与类:\t" + define.getInstance().getClass().getName() + ".java\n");
							msg.append("方法:\t" + define.getMethod().getName() );
							msg.append("\n========================================================================\n");
							throw new ServletException(msg.toString());
						} else {
							mappinfos.put(mappinfo, new MappingDefine(instance, method));
						}
					}
				}
			} catch (ClassNotFoundException | InstantiationException | IllegalAccessException | SecurityException e) {
				e.printStackTrace();
			}
		}
	}

	public static Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
		Object instance = define.getInstance();
		Method method = define.getMethod();
		Object result = null;
		try {
			Parameter[] types = method.getParameters();
			if (types.length == 0) {
				result = method.invoke(instance);
			} else {
				Object[] args = prepare(types, req, resp);
				result = method.invoke(instance, args);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

	private static Object[] prepare(Parameter[] params, HttpServletRequest req, HttpServletResponse resp) {
		Object[] result = new Object[params.length];
		for (int i = 0; i < params.length; i++) {
			String v = req.getParameter(params[i].getName());
			result[i] = parse(v, params[i].getType(), req, resp);
		}
		return result;
	}

	private static <T> Object parse(String v, Class<T> type, HttpServletRequest req, HttpServletResponse resp) {
		String name = type.getSimpleName().toLowerCase();
		if ("modelandview".equals(name)) {
			return new ModelAndView();
		} else if ("httpservletrequest".equals(name)) {
			return req;
		} else if ("httpservletresponse".equals(name)) {
			return resp;
		} else if ("httpsession".equals(name)) {
			return req.getSession();
		}  else if (type.getClassLoader() != null) {
			return (T) parse(type, req);
		} else if (v == null) {
			return null;
		} else if ("byte".equals(name) || "short".equals(name) || "int".equals(name) || "integer".equals(name)) {
			return Integer.parseInt(v);
		} else if ("long".equals(name)) {
			return Long.parseLong(v);
		} else if ("float".equals(name)) {
			return Float.parseFloat(v);
		} else if ("double".equals(name)) {
			return Double.parseDouble(v);
		} else if ("boolean".equals(name)) {
			return Boolean.parseBoolean(v);
		} 
		return v;
	}

	private static <T> T parse(Class<T> type, HttpServletRequest req) {
		T instance = null;
		try {
			if (type != null && req != null) {
				instance = type.newInstance();
				Field[] fields = type.getDeclaredFields();
				for (Field field : fields) {
					String name = field.getName();
					String value = req.getParameter(name);
					if (value != null) {
						field.setAccessible(true);
						field.set(instance, parse(value, field.getType(), req, null));
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return instance;
	}
}
