/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.simple.utils;

import cn.miw.simple.annotations.Mapping;
import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.beans.ModelAndView;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SWUtil {
    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static List<String> scanPackage(String name, String exclude) {
        ArrayList<String> result = new ArrayList<String>();
        URL url = SWUtil.getClassLoader().getResource(name.replaceAll("\\.", "/"));
        new File(url.getFile()).listFiles(child -> {
            String clsName;
            if (child.isDirectory()) {
                result.addAll(SWUtil.scanPackage(name + "." + child.getName(), exclude));
            } else if (child.getName().endsWith(".class") && !(clsName = name + "." + child.getName().replaceAll("\\.class", "")).equals(exclude)) {
                result.add(clsName);
            }
            return false;
        });
        return result;
    }

    public static void findMapping(List<String> clsNames, Map<String, MappingDefine> mappinfos) throws ServletException {
        for (String className : clsNames) {
            try {
                Method[] methods;
                Class<?> clz = Class.forName(className);
                Mapping mapping = clz.getAnnotation(Mapping.class);
                if (mapping == null) continue;
                String path = mapping.value();
                path = "".equals(path) ? "/" : path;
                path = path.startsWith("/") ? path : "/" + path;
                Object instance = clz.newInstance();
                for (Method method : methods = clz.getDeclaredMethods()) {
                    String pathm = "/" + method.getName();
                    Mapping mapp = method.getAnnotation(Mapping.class);
                    if (mapp != null) {
                        String temp = mapp.value();
                        pathm = "".equals(temp) ? pathm : temp;
                    }
                    pathm = pathm.startsWith("/") ? pathm : "/" + pathm;
                    String mappinfo = (path + pathm).replaceAll("/+", "/");
                    if (mappinfos.containsKey(mappinfo)) {
                        StringBuffer msg = new StringBuffer();
                        msg.append("\n========================================================================\n");
                        msg.append("\u91cd\u590d\u5b9a\u4e49:\t" + mappinfo + "\n");
                        msg.append("\u5728\u7c7b:\t" + clz.getName() + ".java\n");
                        msg.append("\u65b9\u6cd5:\t" + method.getName());
                        MappingDefine define = mappinfos.get(mappinfo);
                        msg.append("\n========================================================================\n");
                        msg.append("\u4e0e\u7c7b:\t" + define.getInstance().getClass().getName() + ".java\n");
                        msg.append("\u65b9\u6cd5:\t" + define.getMethod().getName());
                        msg.append("\n========================================================================\n");
                        throw new ServletException(msg.toString());
                    }
                    mappinfos.put(mappinfo, new MappingDefine(instance, method));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
        Object instance = define.getInstance();
        Method method = define.getMethod();
        Object result = null;
        try {
            Parameter[] types = method.getParameters();
            if (types.length == 0) {
                result = method.invoke(instance, new Object[0]);
            } else {
                Object[] args = SWUtil.prepare(types, req, resp);
                result = method.invoke(instance, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Object[] prepare(Parameter[] params, HttpServletRequest req, HttpServletResponse resp) {
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            String v = req.getParameter(params[i].getName());
            result[i] = SWUtil.parse(v, params[i].getType(), req, resp);
        }
        return result;
    }

    private static <T> Object parse(String v, Class<T> type, HttpServletRequest req, HttpServletResponse resp) {
        String name = type.getSimpleName().toLowerCase();
        if ("modelandview".equals(name)) {
            return new ModelAndView();
        }
        if ("httpservletrequest".equals(name)) {
            return req;
        }
        if ("httpservletresponse".equals(name)) {
            return resp;
        }
        if ("httpsession".equals(name)) {
            return req.getSession();
        }
        if (type.getClassLoader() != null) {
            return SWUtil.parse(type, req);
        }
        if (v == null) {
            return null;
        }
        if ("byte".equals(name) || "short".equals(name) || "int".equals(name) || "integer".equals(name)) {
            return Integer.parseInt(v);
        }
        if ("long".equals(name)) {
            return Long.parseLong(v);
        }
        if ("float".equals(name)) {
            return Float.valueOf(Float.parseFloat(v));
        }
        if ("double".equals(name)) {
            return Double.parseDouble(v);
        }
        if ("boolean".equals(name)) {
            return Boolean.parseBoolean(v);
        }
        return v;
    }

    private static <T> T parse(Class<T> type, HttpServletRequest req) {
        T instance = null;
        try {
            if (type != null && req != null) {
                Field[] fields;
                instance = type.newInstance();
                for (Field field : fields = type.getDeclaredFields()) {
                    String name = field.getName();
                    String value = req.getParameter(name);
                    if (value == null) continue;
                    field.setAccessible(true);
                    field.set(instance, SWUtil.parse(value, field.getType(), req, null));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }
}

