package cn.miw.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSON;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;

import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.beans.ModelAndView;
@MultipartConfig
public abstract class SimpleWebDispatcher extends HttpServlet implements Filter {

	private static final long serialVersionUID = 1L;
	private String packageName;
	private CharSequence contextPath;
	private ServletContext context;
	private SimpleWeb container = SimpleWeb.me();

	abstract public void config(SimpleWeb me);

	@Override
	protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		req.setCharacterEncoding("utf-8");
		resp.setCharacterEncoding("utf-8");
		resp.setContentType("text/html;charset=utf-8");

		String mappinginfo = req.getRequestURI().replace(contextPath, "");
		MappingDefine define = container.findMapping(mappinginfo);
		if (define == null) {
			resp.getWriter().append("功能还在开发中");
			return;
		}
		Map<String, Object> _RenderData = prepareRenderData(req);

		Object result = container.exec(mappinginfo, define, req, resp);
		
		String view = null;
		if (result instanceof ModelAndView) {
			_RenderData.putAll(((ModelAndView) result).allData());
			view = ((ModelAndView) result).getView();
		} else if (result instanceof String) {
			if(((String)result).startsWith("f:")||((String)result).startsWith("r:")) {
				view = (String)result;
			}
		} else if (result instanceof File) {
			File file = (File) result;
			resp.setContentType("application/octet-stream");
			resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "utf-8"));
			ServletOutputStream os = resp.getOutputStream();
			FileInputStream input = new FileInputStream(file);
			int size = 0;
            byte[] buffer = new byte[1024];
            while ((size = input.read(buffer)) != -1) {
                os.write(buffer, 0, size);
            }
            os.close();
            input.close();
			return;
		}
		if (view != null) {
			if (view.startsWith("f:")) {
				req.getRequestDispatcher(contextPath+view.substring(2)).forward(req, resp);
			} else if (view.startsWith("r:")) {
				resp.sendRedirect(contextPath+view.substring(2));
			} else {
				Template template = Engine.use().getTemplate(view);
				template.render(_RenderData, resp.getWriter());
			}
		} else if (result != null) {
			resp.setContentType("application/json;charset=utf-8");
			resp.getWriter().append(JSON.toJSONString(result));
		}
	}

	private Map<String, Object> prepareRenderData(HttpServletRequest req) {
		Map<String, Object> _RenderData = new HashMap<>();
		Enumeration<String> names = req.getSession().getAttributeNames();
		Map<String, Object> sessionMap = new HashMap<>();
		while (names.hasMoreElements()) {
			String name = (String) names.nextElement();
			sessionMap.put(name, req.getSession().getAttribute(name));
		}
		_RenderData.put("session", sessionMap);
		names = req.getAttributeNames();
		Map<String, Object> requestMap = new HashMap<>();
		while (names.hasMoreElements()) {
			String name = (String) names.nextElement();
			requestMap.put(name, req.getAttribute(name));
		}
		_RenderData.put("request", requestMap);
		names = req.getParameterNames();
		Map<String, Object> paramMap = new HashMap<>();
		while (names.hasMoreElements()) {
			String name = (String) names.nextElement();
			paramMap.put(name, req.getParameter(name));
		}
		_RenderData.put("param", paramMap);
		_RenderData.put("root", contextPath);
		return _RenderData;
	}

	// Servlet初始化
	@Override
	public void init(ServletConfig config) throws ServletException {
		packageName = getPackageName(config.getInitParameter("scanPackage"));
		context = config.getServletContext();
		initDispatcher();
	}

	private void initDispatcher() throws ServletException {
		contextPath = context.getContextPath();
		container.init(context, packageName);
		config(container);
	}

	/////////////////// IFilter实现//////////////////////////////////////
	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		service(request, response);
		chain.doFilter(request, response);
	}

	// IFilter初始
	@Override
	public void init(FilterConfig config) throws ServletException {
		packageName = getPackageName(config.getInitParameter("scanPackage"));
		context = config.getServletContext();
		initDispatcher();
	}

	private String getPackageName(String packageName) {
		if (packageName == null || "".equals(packageName)) {
			packageName = getClass().getPackage().getName();
		}
		return packageName;
	}

	protected ServletContext getContext() {
		return context;
	}

	@Override
	public void destroy() {
		container.destroy();
		super.destroy();
	}

}
