package cn.miw.simple.aop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

@SuppressWarnings("unchecked")
public class SimpleFactory {
	private static Object _create(Object obj, ISimpleHandler handler) {
		Class<?>[] interfaces = obj.getClass().getInterfaces();
		Object target;
		if (interfaces.length > 0) {
			target = Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaces, handler);
		} else {
			target = Enhancer.create(obj.getClass(), handler);
			;
		}
		return target;
	}

	public static <T> T create(Object obj, ISimpleHandler handler) {
		return (T) _create(obj, handler);
	}

	public static <T> T create(String className, ISimpleHandler handler) {
		Object obj = null;
		try {
			obj = _create(Class.forName(className).newInstance(), handler);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (T) obj;
	}

	public static <T> T create(Class<?> clz, ISimpleHandler handler) {
		Object obj = null;
		try {
			obj = _create(clz.newInstance(), handler);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (T) obj;
	}

	public interface ISimpleHandler extends InvocationHandler, MethodInterceptor {

		void before(Object proxy, Method method, Object[] args);

		void after(Object proxy, Method method, Object[] args, Object result);
	}
}