/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.simple;

import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.utils.SimpleWebUtil;
import com.jfinal.template.Engine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleWeb {
    private List<String> clsNames = new ArrayList<String>();
    private Map<String, MappingDefine> mappinfos = new ConcurrentHashMap<String, MappingDefine>(16);
    private ServletContext context;
    private String rootPath;
    private String uploadPath;

    private SimpleWeb() {
    }

    public static SimpleWeb me() {
        return SimpleWebInstance.instance;
    }

    public void init(ServletContext context, String packageName) throws ServletException {
        this.context = context;
        this.setRootPath(context.getRealPath("/"), true);
        this.setUploadPath(context.getRealPath("/"), true);
        this.clsNames.addAll(SimpleWebUtil.scanPackage(packageName, this.getClass().getName()));
        SimpleWebUtil.findMapping(this.clsNames, this.mappinfos);
        this.printlogo();
    }

    public void setRootPath(String path, boolean abs) {
        Engine engine = Engine.use();
        this.rootPath = abs ? path : this.context.getRealPath(("/" + path).replaceAll("/+", "/"));
        engine.setBaseTemplatePath(this.rootPath);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setUploadPath(String path, boolean abs) {
        this.uploadPath = abs ? path : this.context.getRealPath(("/" + path).replaceAll("/+", "/"));
    }

    public String getUploadPath() {
        return this.uploadPath;
    }

    public MappingDefine findMapping(String mappinfo) {
        return this.mappinfos.get(mappinfo);
    }

    public Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
        return SimpleWebUtil.exec(mappinfo, define, req, resp);
    }

    public void destroy() {
        this.mappinfos.forEach((key, define) -> define.clear());
        this.mappinfos.clear();
        this.mappinfos = null;
        this.clsNames.clear();
        this.clsNames = null;
    }

    public void printlogo() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("========================================================================\n");
        sb.append("==      ========================  =========  ====  ====  =========  ====\n");
        sb.append("=  ====  =======================  =========  ====  ====  =========  ====\n");
        sb.append("=  ====  =======================  =========  ====  ====  =========  ====\n");
        sb.append("==  =======  ==  =  = ===    ===  ===   ===  ====  ====  ===   ===  ====\n");
        sb.append("====  =========        ==  =  ==  ==  =  ==   ==    ==  ===  =  ==    ==\n");
        sb.append("======  ===  ==  =  =  ==  =  ==  ==     ===  ==    ==  ===     ==  =  =\n");
        sb.append("=  ====  ==  ==  =  =  ==    ===  ==  ======  ==    ==  ===  =====  =  =\n");
        sb.append("=  ====  ==  ==  =  =  ==  =====  ==  =  ====    ==    ====  =  ==  =  =\n");
        sb.append("==      ===  ==  =  =  ==  =====  ===   ======  ====  ======   ===    ==\n");
        sb.append("========================================================================\n");
        System.err.println(sb.toString());
    }

    private static class SimpleWebInstance {
        public static final SimpleWeb instance = new SimpleWeb();

        private SimpleWebInstance() {
        }
    }
}

