/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.simple;

import cn.miw.simple.SimpleWeb;
import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.beans.ModelAndView;
import com.alibaba.fastjson.JSON;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@MultipartConfig
public abstract class SimpleWebDispatcher
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = 1L;
    private String packageName;
    private CharSequence contextPath;
    private ServletContext context;
    private SimpleWeb container = SimpleWeb.me();

    public abstract void config(SimpleWeb var1);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("utf-8");
        resp.setCharacterEncoding("utf-8");
        resp.setContentType("text/html;charset=utf-8");
        String mappinginfo = req.getRequestURI().replace(this.contextPath, "");
        MappingDefine define = this.container.findMapping(mappinginfo);
        if (define == null) {
            resp.getWriter().append("\u529f\u80fd\u8fd8\u5728\u5f00\u53d1\u4e2d");
            return;
        }
        Map<String, Object> _RenderData = this.prepareRenderData(req);
        Object result = this.container.exec(mappinginfo, define, req, resp);
        String view = null;
        if (result instanceof ModelAndView) {
            _RenderData.putAll(((ModelAndView)result).allData());
            view = ((ModelAndView)result).getView();
        } else if (result instanceof String) {
            if (((String)result).startsWith("f:") || ((String)result).startsWith("r:")) {
                view = (String)result;
            }
        } else if (result instanceof File) {
            File file = (File)result;
            resp.setContentType("application/octet-stream");
            resp.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "utf-8"));
            ServletOutputStream os = resp.getOutputStream();
            FileInputStream input = new FileInputStream(file);
            int size = 0;
            byte[] buffer = new byte[1024];
            while ((size = input.read(buffer)) != -1) {
                os.write(buffer, 0, size);
            }
            os.close();
            input.close();
            return;
        }
        if (view != null) {
            if (view.startsWith("f:")) {
                req.getRequestDispatcher(this.contextPath + view.substring(2)).forward((ServletRequest)req, (ServletResponse)resp);
            } else if (view.startsWith("r:")) {
                resp.sendRedirect(this.contextPath + view.substring(2));
            } else {
                Template template = Engine.use().getTemplate(view);
                template.render(_RenderData, (Writer)resp.getWriter());
            }
        } else if (result != null) {
            resp.setContentType("application/json;charset=utf-8");
            resp.getWriter().append(JSON.toJSONString((Object)result));
        }
    }

    private Map<String, Object> prepareRenderData(HttpServletRequest req) {
        HashMap<String, Object> _RenderData = new HashMap<String, Object>();
        Enumeration names = req.getSession().getAttributeNames();
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            sessionMap.put(name, req.getSession().getAttribute(name));
        }
        _RenderData.put("session", sessionMap);
        names = req.getAttributeNames();
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            requestMap.put(name, req.getAttribute(name));
        }
        _RenderData.put("request", requestMap);
        names = req.getParameterNames();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paramMap.put(name, req.getParameter(name));
        }
        _RenderData.put("param", paramMap);
        _RenderData.put("root", this.contextPath);
        return _RenderData;
    }

    public void init(ServletConfig config) throws ServletException {
        this.packageName = this.getPackageName(config.getInitParameter("scanPackage"));
        this.context = config.getServletContext();
        this.initDispatcher();
    }

    private void initDispatcher() throws ServletException {
        this.contextPath = this.context.getContextPath();
        this.container.init(this.context, this.packageName);
        this.config(this.container);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.service(request, response);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.packageName = this.getPackageName(config.getInitParameter("scanPackage"));
        this.context = config.getServletContext();
        this.initDispatcher();
    }

    private String getPackageName(String packageName) {
        if (packageName == null || "".equals(packageName)) {
            packageName = ((Object)((Object)this)).getClass().getPackage().getName();
        }
        return packageName;
    }

    protected ServletContext getContext() {
        return this.context;
    }

    public void destroy() {
        this.container.destroy();
        super.destroy();
    }
}

