/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.simple.utils;

import cn.miw.simple.SimpleWeb;
import cn.miw.simple.annotations.Mapping;
import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.beans.ModelAndView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

public class SimpleWebUtil {
    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static List<String> scanPackage(String name, String exclude) {
        ArrayList<String> result = new ArrayList<String>();
        URL url = SimpleWebUtil.getClassLoader().getResource(name.replaceAll("\\.", "/"));
        new File(url.getFile()).listFiles(child -> {
            String clsName;
            if (child.isDirectory()) {
                result.addAll(SimpleWebUtil.scanPackage(name + "." + child.getName(), exclude));
            } else if (child.getName().endsWith(".class") && !(clsName = name + "." + child.getName().replaceAll("\\.class", "")).equals(exclude)) {
                result.add(clsName);
            }
            return false;
        });
        return result;
    }

    public static void findMapping(List<String> clsNames, Map<String, MappingDefine> mappinfos) throws ServletException {
        for (String className : clsNames) {
            try {
                Method[] methods;
                Class<?> clz = Class.forName(className);
                Mapping mapping = clz.getAnnotation(Mapping.class);
                if (mapping == null) continue;
                String path = mapping.value();
                path = "".equals(path) ? "/" : path;
                path = path.startsWith("/") ? path : "/" + path;
                Object instance = clz.newInstance();
                for (Method method : methods = clz.getDeclaredMethods()) {
                    String pathm = "/" + method.getName();
                    Mapping mapp = method.getAnnotation(Mapping.class);
                    if (mapp != null) {
                        String temp = mapp.value();
                        pathm = "".equals(temp) ? pathm : temp;
                    }
                    pathm = pathm.startsWith("/") ? pathm : "/" + pathm;
                    String mappinfo = (path + pathm).replaceAll("/+", "/");
                    if (mappinfos.containsKey(mappinfo)) {
                        StringBuffer msg = new StringBuffer();
                        msg.append("\n========================================================================\n");
                        msg.append("\u91cd\u590d\u5b9a\u4e49:\t" + mappinfo + "\n");
                        msg.append("\u5728\u7c7b:\t" + clz.getName() + ".java\n");
                        msg.append("\u65b9\u6cd5:\t" + method.getName());
                        MappingDefine define = mappinfos.get(mappinfo);
                        msg.append("\n========================================================================\n");
                        msg.append("\u4e0e\u7c7b:\t" + define.getInstance().getClass().getName() + ".java\n");
                        msg.append("\u65b9\u6cd5:\t" + define.getMethod().getName());
                        msg.append("\n========================================================================\n");
                        throw new ServletException(msg.toString());
                    }
                    mappinfos.put(mappinfo, new MappingDefine(instance, method));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
        Object instance = define.getInstance();
        Method method = define.getMethod();
        Object result = null;
        try {
            Parameter[] parameters = method.getParameters();
            if (parameters.length == 0) {
                result = method.invoke(instance, new Object[0]);
            } else {
                Object[] args = SimpleWebUtil.prepare(parameters, req, resp);
                result = method.invoke(instance, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static Object[] prepare(Parameter[] params, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Object[] result = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = SimpleWebUtil.parse(params[i].getName(), params[i].getType(), req, resp);
        }
        return result;
    }

    private static <T> Object parse(String paramName, Class<T> type, HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String paramTypeName = type.getSimpleName().toLowerCase();
        if ("modelandview".equals(paramTypeName)) {
            return new ModelAndView();
        }
        if ("httpservletrequest".equals(paramTypeName)) {
            return req;
        }
        if ("httpservletresponse".equals(paramTypeName)) {
            return resp;
        }
        if ("httpsession".equals(paramTypeName)) {
            return req.getSession();
        }
        if (type.getClassLoader() != null) {
            return SimpleWebUtil.parse(type, req);
        }
        Object v = SimpleWebUtil.getValueFromRequest(paramName, req);
        if (v == null) {
            return null;
        }
        if ("byte".equals(paramTypeName) || "short".equals(paramTypeName) || "int".equals(paramTypeName) || "integer".equals(paramTypeName)) {
            return Integer.parseInt((String)v);
        }
        if ("long".equals(paramTypeName)) {
            return Long.parseLong((String)v);
        }
        if ("float".equals(paramTypeName)) {
            return Float.valueOf(Float.parseFloat((String)v));
        }
        if ("double".equals(paramTypeName)) {
            return Double.parseDouble((String)v);
        }
        if ("boolean".equals(paramTypeName)) {
            return Boolean.parseBoolean((String)v);
        }
        return v;
    }

    private static Object getValueFromRequest(String paramName, HttpServletRequest req) throws ServletException {
        String contentType = req.getContentType();
        if (null != contentType && contentType.startsWith("multipart/")) {
            try {
                Part p = req.getPart(paramName);
                String partContentType = p.getContentType();
                InputStream input = p.getInputStream();
                if (null == partContentType) {
                    byte[] b = new byte[(int)p.getSize()];
                    input.read(b);
                    input.close();
                    return new String(b);
                }
                String fileName = p.getSubmittedFileName();
                fileName = SimpleWeb.me().getUploadPath() + "/" + fileName;
                File file = new File(fileName);
                FileOutputStream fos = new FileOutputStream(file, false);
                int size = 0;
                byte[] buffer = new byte[1024];
                while ((size = input.read(buffer)) != -1) {
                    fos.write(buffer, 0, size);
                }
                fos.close();
                input.close();
                return file;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return req.getParameter(paramName);
    }

    private static <T> T parse(Class<T> type, HttpServletRequest req) {
        T instance = null;
        try {
            if (type != null && req != null) {
                Field[] fields;
                instance = type.newInstance();
                for (Field field : fields = SimpleWebUtil.getFields(type)) {
                    String name = field.getName();
                    Object value = SimpleWebUtil.getValueFromRequest(name, req);
                    if (value == null) continue;
                    field.setAccessible(true);
                    field.set(instance, SimpleWebUtil.parse(name, field.getType(), req, null));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    public static Field[] getFields(Class<?> type) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<?> clz = type; clz != null; clz = clz.getSuperclass()) {
            fieldsList.addAll(Arrays.asList(clz.getDeclaredFields()));
        }
        return fieldsList.toArray(new Field[0]);
    }
}

