package cn.miw.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jfinal.template.Engine;

import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.utils.SimpleWebUtil;

public class SimpleWeb {

	private List<String> clsNames = new ArrayList<String>();
	private Map<String, MappingDefine> mappinfos = new ConcurrentHashMap<String, MappingDefine>(16);
	private ServletContext context;
	private String rootPath;
	private String uploadPath;

	private SimpleWeb() {
	}

	public static SimpleWeb me() {
		return SimpleWebInstance.instance;
	}

	private static class SimpleWebInstance {
		public final static SimpleWeb instance = new SimpleWeb();
	}

	public void init(ServletContext context, String packageName) throws ServletException {
		this.context = context;
		setRootPath(context.getRealPath("/"), true);
		setUploadPath(context.getRealPath("/"), true);
		clsNames.addAll(SimpleWebUtil.scanPackage(packageName, getClass().getName()));
		SimpleWebUtil.findMapping(clsNames, mappinfos);
		printlogo();
	}

	public void setRootPath(String path, boolean abs) {
		Engine engine = Engine.use();
		rootPath = abs ? path : context.getRealPath(("/" + path).replaceAll("/+", "/"));
		engine.setBaseTemplatePath(rootPath);
	}
	public String getRootPath() {
		return rootPath;
	}
	public void setUploadPath(String path, boolean abs) {
		uploadPath = abs ? path : context.getRealPath(("/" + path).replaceAll("/+", "/"));
	}
	public String getUploadPath() {
		return uploadPath;
	}
	public MappingDefine findMapping(String mappinfo) {
		return mappinfos.get(mappinfo);
	}

	public Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
		return SimpleWebUtil.exec(mappinfo, define, req, resp);
	}

	public void destroy() {
		mappinfos.forEach((key, define) -> {
			define.clear();
		});
		mappinfos.clear();
		mappinfos = null;
		clsNames.clear();
		clsNames = null;
	}
	
	public void printlogo() {
		StringBuffer sb = new StringBuffer();
		sb.append("\n");
		sb.append("========================================================================\n");
		sb.append("==      ========================  =========  ====  ====  =========  ====\n");
		sb.append("=  ====  =======================  =========  ====  ====  =========  ====\n");
		sb.append("=  ====  =======================  =========  ====  ====  =========  ====\n");
		sb.append("==  =======  ==  =  = ===    ===  ===   ===  ====  ====  ===   ===  ====\n");
		sb.append("====  =========        ==  =  ==  ==  =  ==   ==    ==  ===  =  ==    ==\n");
		sb.append("======  ===  ==  =  =  ==  =  ==  ==     ===  ==    ==  ===     ==  =  =\n");
		sb.append("=  ====  ==  ==  =  =  ==    ===  ==  ======  ==    ==  ===  =====  =  =\n");
		sb.append("=  ====  ==  ==  =  =  ==  =====  ==  =  ====    ==    ====  =  ==  =  =\n");
		sb.append("==      ===  ==  =  =  ==  =====  ===   ======  ====  ======   ===    ==\n");
		sb.append("========================================================================\n");
		System.err.println(sb.toString());
	}
}
