package cn.miw.simple.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

import cn.miw.simple.SimpleWeb;
import cn.miw.simple.annotations.Mapping;
import cn.miw.simple.beans.MappingDefine;
import cn.miw.simple.beans.ModelAndView;

public class SimpleWebUtil {
	public static ClassLoader getClassLoader() {
		return Thread.currentThread().getContextClassLoader();
	}

	public static List<String> scanPackage(String name, String exclude) {
		List<String> result = new ArrayList<>();
		URL url = getClassLoader().getResource(name.replaceAll("\\.", "/"));
		new File(url.getFile()).listFiles(child -> {
			if (child.isDirectory()) {
				result.addAll(scanPackage(name + "." + child.getName(), exclude));
			} else if (child.getName().endsWith(".class")) {
				String clsName = name + "." + child.getName().replaceAll("\\.class", "");
				if (!clsName.equals(exclude)) {
					result.add(clsName);
				}
			}
			return false;
		});
		return result;
	}

	public static void findMapping(List<String> clsNames, Map<String, MappingDefine> mappinfos)
			throws ServletException {
		for (String className : clsNames) {
			try {
				Class<?> clz = Class.forName(className);
				Mapping mapping = clz.getAnnotation(Mapping.class);
				if (mapping != null) {
					String path = mapping.value();
					path = "".equals(path) ? "/" : path;
					path = path.startsWith("/") ? path : "/" + path;
					Object instance = clz.newInstance();
					Method[] methods = clz.getDeclaredMethods();
					for (Method method : methods) {
						String pathm = "/" + method.getName();
						Mapping mapp = method.getAnnotation(Mapping.class);
						if (mapp != null) {
							String temp = mapp.value();
							pathm = "".equals(temp) ? pathm : temp;
						}
						pathm = pathm.startsWith("/") ? pathm : "/" + pathm;
						String mappinfo = (path + pathm).replaceAll("/+", "/");
						if (mappinfos.containsKey(mappinfo)) {
							StringBuffer msg = new StringBuffer();
							msg.append("\n========================================================================\n");
							msg.append("重复定义:\t" + mappinfo + "\n");
							msg.append("在类:\t" + clz.getName() + ".java\n");
							msg.append("方法:\t" + method.getName());
							MappingDefine define = mappinfos.get(mappinfo);
							msg.append("\n========================================================================\n");
							msg.append("与类:\t" + define.getInstance().getClass().getName() + ".java\n");
							msg.append("方法:\t" + define.getMethod().getName());
							msg.append("\n========================================================================\n");
							throw new ServletException(msg.toString());
						} else {
							mappinfos.put(mappinfo, new MappingDefine(instance, method));
						}
					}
				}
			} catch (ClassNotFoundException | InstantiationException | IllegalAccessException | SecurityException e) {
				e.printStackTrace();
			}
		}
	}

	public static Object exec(String mappinfo, MappingDefine define, HttpServletRequest req, HttpServletResponse resp) {
		Object instance = define.getInstance();
		Method method = define.getMethod();
		Object result = null;
		try {
			Parameter[] parameters = method.getParameters();
			if (parameters.length == 0) {
				result = method.invoke(instance);
			} else {
				Object[] args = prepare(parameters, req, resp);
				result = method.invoke(instance, args);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}

	private static Object[] prepare(Parameter[] params, HttpServletRequest req, HttpServletResponse resp)
			throws IOException, ServletException {
		Object[] result = new Object[params.length];
		for (int i = 0; i < params.length; i++) {
			result[i] = parse(params[i].getName(), params[i].getType(), req, resp);
		}
		return result;
	}

	private static <T> Object parse(String paramName, Class<T> type, HttpServletRequest req, HttpServletResponse resp)
			throws ServletException {
		String paramTypeName = type.getSimpleName().toLowerCase();
		if ("modelandview".equals(paramTypeName)) {
			return new ModelAndView();
		} else if ("httpservletrequest".equals(paramTypeName)) {
			return req;
		} else if ("httpservletresponse".equals(paramTypeName)) {
			return resp;
		} else if ("httpsession".equals(paramTypeName)) {
			return req.getSession();
		} else if (type.getClassLoader() != null) {
			return (T) parse(type, req);
		} else {
			Object v = getValueFromRequest(paramName, req);
			if (v == null) {
				return null;
			} else if ("byte".equals(paramTypeName) || "short".equals(paramTypeName) || "int".equals(paramTypeName)
					|| "integer".equals(paramTypeName)) {
				return Integer.parseInt((String)v);
			} else if ("long".equals(paramTypeName)) {
				return Long.parseLong((String)v);
			} else if ("float".equals(paramTypeName)) {
				return Float.parseFloat((String)v);
			} else if ("double".equals(paramTypeName)) {
				return Double.parseDouble((String)v);
			} else if ("boolean".equals(paramTypeName)) {
				return Boolean.parseBoolean((String)v);
			} else {
				return v;
			}
		}
	}

	private static Object getValueFromRequest(String paramName, HttpServletRequest req) throws ServletException {
		String contentType = req.getContentType();
		if (null != contentType && contentType.startsWith("multipart/")) {
			try {
				Part p = req.getPart(paramName);
				String partContentType = p.getContentType();
				InputStream input = p.getInputStream();
				if (null == partContentType) {
					byte[] b = new byte[(int) p.getSize()];
					input.read(b);
					input.close();
					return new String(b);
				} else {
					String fileName = p.getSubmittedFileName();
					fileName = SimpleWeb.me().getUploadPath() + "/" + fileName;
					File file = new File(fileName);
					FileOutputStream fos = new FileOutputStream(file, false);
					int size = 0;
					byte[] buffer = new byte[1024];
					while ((size = input.read(buffer)) != -1) {
						fos.write(buffer, 0, size);
					}
					fos.close();
					input.close();
					return file;
				}
			} catch (IOException e) {
				e.printStackTrace();
				return null;
			}
		} else {
			return req.getParameter(paramName);
		}
	}

	private static <T> T parse(Class<T> type, HttpServletRequest req) {
		T instance = null;
		try {
			if (type != null && req != null) {
				instance = type.newInstance();
				Field[] fields = getFields(type);
				for (Field field : fields) {
					String name = field.getName();
					Object value = getValueFromRequest(name,req);
					if (value != null) {
						field.setAccessible(true);
						field.set(instance, parse(name, field.getType(), req, null));
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return instance;
	}

	public static Field[] getFields(Class<?> type) {
		List<Field> fieldsList = new ArrayList<Field>();
		Class<?> clz = type;
		while (clz != null) {
			fieldsList.addAll(Arrays.asList(clz.getDeclaredFields()));
			clz = clz.getSuperclass();
		}
		return fieldsList.toArray(new Field[] {});
	}
}
