package com.t6sm.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

import com.jfinal.template.ext.spring.JFinalViewResolver;
import com.jfinal.template.source.ClassPathSourceFactory;

@Configuration
@ConditionalOnClass({ EnjoyAutoConfig.ViewResolver.class })
@ConditionalOnProperty(prefix = "enjoy", value = "enabled", matchIfMissing = true)
@ConfigurationProperties(prefix="enjoy")
public class EnjoyAutoConfig {

	private String suffix=".html";
	private String contentType="text/html;charset=UTF-8";
	private String baseTemplatePath="/templates/";

	
	public String getSuffix() {
		return suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public String getBaseTemplatePath() {
		return baseTemplatePath;
	}

	public void setBaseTemplatePath(String baseTemplatePath) {
		this.baseTemplatePath = baseTemplatePath;
	}

	@Bean
	@ConditionalOnMissingBean({ EnjoyAutoConfig.ViewResolver.class })
	public ViewResolver getJFinalViewResolver() {
		ViewResolver jfr = new ViewResolver();
		jfr.setDevMode(true);
		jfr.setSessionInView(true);
		jfr.setSourceFactory(new ClassPathSourceFactory());
		jfr.setBaseTemplatePath(baseTemplatePath);
		jfr.setSuffix(suffix);
		jfr.setContentType(contentType);
		jfr.setOrder(0);
		return jfr;
	}

	public class ViewResolver extends JFinalViewResolver implements ApplicationListener<ContextRefreshedEvent> {

		@Override
		public void onApplicationEvent(ContextRefreshedEvent event) {
			try {
				getEngine().addSharedObject("root", getServletContext().getContextPath());
			} catch (IllegalStateException e) {
			}

		}
	}
}
