/*
 * Decompiled with CFR 0.152.
 */
package com.t6sm.config;

import com.jfinal.template.ext.spring.JFinalViewResolver;
import com.jfinal.template.source.ClassPathSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ConditionalOnClass(value={ViewResolver.class})
@ConditionalOnProperty(prefix="enjoy", value={"enabled"}, matchIfMissing=true)
@ConfigurationProperties(prefix="enjoy")
public class EnjoyAutoConfig {
    private String suffix = ".html";
    private String contentType = "text/html;charset=UTF-8";
    private String baseTemplatePath = "/templates/";

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getBaseTemplatePath() {
        return this.baseTemplatePath;
    }

    public void setBaseTemplatePath(String baseTemplatePath) {
        this.baseTemplatePath = baseTemplatePath;
    }

    @Bean
    @ConditionalOnMissingBean(value={ViewResolver.class})
    public ViewResolver getJFinalViewResolver() {
        ViewResolver jfr = new ViewResolver();
        jfr.setDevMode(true);
        jfr.setSessionInView(true);
        jfr.setSourceFactory((ISourceFactory)new ClassPathSourceFactory());
        jfr.setBaseTemplatePath(this.baseTemplatePath);
        jfr.setSuffix(this.suffix);
        jfr.setContentType(this.contentType);
        jfr.setOrder(0);
        return jfr;
    }

    public class ViewResolver
    extends JFinalViewResolver
    implements ApplicationListener<ContextRefreshedEvent> {
        private boolean inited = false;

        public void onApplicationEvent(ContextRefreshedEvent event) {
            try {
                if (!this.inited) {
                    this.getEngine().addSharedObject("root", (Object)this.getServletContext().getContextPath());
                    this.inited = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

