package cn.miw.gen.utils;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

import cn.hutool.json.JSONObject;
import lombok.extern.slf4j.Slf4j;

@Aspect
@Slf4j
public class JSONAop {

	@Around("@annotation(org.springframework.web.bind.annotation.ResponseBody)")
	public Object renderLog(ProceedingJoinPoint point) throws Throwable {
		Object result = exec(point);
		return result;
	}
	
	private Object exec(ProceedingJoinPoint point) throws Throwable {
		log.info(">>>> ResponseBody结果封装开始:{}.{}",point.getTarget().getClass(), point.getSignature().getName());
		long begin = System.currentTimeMillis();
		Object result = point.proceed();
		long end = System.currentTimeMillis();
		long takeTime = end - begin;
		log.info("<<<< ResponseBody结果封装结束:{}.{} ，耗时：{} 毫秒 ====", point.getTarget().getClass(), point.getSignature().getName(),takeTime);
		return new JSONObject(result);
	}
}
