var ws = null;
function setConnected(connected) {
	//连接成功
}
//url="/sockjs/websocket"
function connect(url) {
	ws = new SockJS(url);
	ws.onopen = function() {
		setConnected(true);
	};
	ws.onmessage = function(event) {
		//log('Received: ' + event.data);
		//log(JSON.stringify(event));
		//showTips(event.data);
		m = JSON.parse(event.data);
		var msg = {"title": m.title, "content": m.message, "date": new Date().format('MM-dd hh:mm:ss'), "url": m.url};
		//console.log(msg);
		//console.log(event.data);
		
		showNotice(msg,m.type?m.type:'other');
	};
	ws.onclose = function(event) {
		setConnected(false);
		log('Info: connection closed.');
		log(event);
	};
}

function disconnect() {
	if (ws != null) {
		ws.close();
		ws = null;
	}
	setConnected(false);
}

function echo(message) {
	if (ws != null) {
		ws.send(message);
	} 
}


function log(message) {
	//记录日志信息
	//console.log(message);
}
function showTips(msg){
	layer.open({
		type : 1,
		offset : 'rb',
		id : 'tips' + new Date() .getTime(),
		content : '<div style="padding: 20px 20px;">' + msg + '</div>',
		btn : '关闭全部',
		btnAlign : 'c', //按钮居中
		shade : 0, //不显示遮罩
		yes : function() {
			layer.closeAll();
		}
	});
}