package #(package)#(business).controller.admin;
#set(entityName=genName(tableName,0))
import java.util.Arrays;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import #(package)#(business).model.#(entityName);
import #(package)#(business).service.#(entityName)Service;
import cn.miw.gen.utils.BaseController;
import cn.miw.gen.utils.Result;

import lombok.extern.slf4j.Slf4j;

/**
 * #(entityName) 控制器
 * 生成器创建 by mrzhou@miw.cn
 * @date #now('yyyy-MM-dd HH:mm:ss')
 */
 #set(fix=notBlank(business)?business.substring(1)+"/":"")
@Controller
@Slf4j
public class Admin#(entityName) extends BaseController {
	@Autowired private #(entityName)Service service;

	@GetMapping("/#(fix)admin/#(entityName)")
	public String index(String title) {
		active = title;
		return render("/admin/#(fix)#(entityName)/list.html");
	}

	@GetMapping("/#(fix)admin/#(entityName)/edit")
	public String edit(#(getType(pk.type)) id) {
		#(entityName) item = null;
		if (id != null) {
			item = service.getById(id);
		}
		item = item != null ? item : new #(entityName)();
		setAttr("item", item);
		return render("/admin/#(fix)#(entityName)/edit.html");
	}


	@PostMapping("/#(fix)admin/#(entityName)/list")
	@ResponseBody
	public Object list(Integer page, Integer limit, String keyword) {
		log.info("{},{},{},{}", page, limit, keyword);
		return new Result(service.page(page, limit, keyword));
	}

	@PostMapping("/#(fix)admin/#(entityName)/save")
	@ResponseBody
	public Object save(@RequestBody #(entityName) json) {
		return new Result(json);
	}

	@PostMapping("/#(fix)admin/#(entityName)/del")
	@ResponseBody
	public Object del(@RequestBody #(getType(pk.type))[] ids) {
		if(ids!=null) service.removeBatchByIds(Arrays.asList(ids));
		return new Result(ids);
	}
}
