/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.gen.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.json.JSONObject;
import cn.miw.gen.utils.SimpleUtil;
import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.ext.directive.NowDirective;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class GenUtil {
    private DataSource ds;

    GenUtil() {
    }

    public GenUtil(DataSource ds) {
        this.ds = ds;
    }

    public void gen(String pkg, String business) {
        List tables = MetaUtil.getTables((DataSource)this.ds);
        this.gen(pkg, business, tables);
    }

    public void gen(String pkg, String business, List<String> tables) {
        this.gen(pkg, business, tables, "/src/main/java", "/src/main/resources/templates", true);
    }

    public void gen(String pkg, String business, List<String> tables, String javaPath, String tempPath, boolean override) {
        JSONObject data = new JSONObject().set("package", (Object)pkg);
        for (String tableName : tables) {
            data.set("tableName", (Object)tableName).set("business", (Object)business);
            Table tableMeta = MetaUtil.getTableMeta((DataSource)this.ds, (String)tableName);
            Set pkNames = tableMeta.getPkNames();
            String pk = CollUtil.isNotEmpty((Collection)pkNames) ? (String)pkNames.stream().findFirst().get() : null;
            Column pkCol = null;
            Collection fields = tableMeta.getColumns();
            pkCol = pk != null ? fields.stream().filter(x -> x.getName().equals(pk)).findFirst().get() : (Column)fields.stream().findFirst().get();
            data.set("fields", (Object)fields).set("pk", (Object)pkCol);
            if (!override) continue;
            String path = this.buildDir(javaPath, pkg, business, "model");
            String target = path + File.separator + SimpleUtil.genName(tableName, 0) + ".java";
            this.genFile("/tpl/model.tpl", (Map<?, ?>)data, new File(target));
            path = this.buildDir(javaPath, pkg, business, "mapper");
            target = path + File.separator + SimpleUtil.genName(tableName, 0) + "Mapper.java";
            this.genFile("/tpl/Mapper.tpl", (Map<?, ?>)data, new File(target));
            path = this.buildDir(javaPath, pkg, business, "service");
            target = path + File.separator + SimpleUtil.genName(tableName, 0) + "Service.java";
            this.genFile("/tpl/Service.tpl", (Map<?, ?>)data, new File(target));
            path = this.buildDir(javaPath, pkg, business, "service.impl");
            target = path + File.separator + SimpleUtil.genName(tableName, 0) + "ServiceImpl.java";
            this.genFile("/tpl/Impl.tpl", (Map<?, ?>)data, new File(target));
            path = this.buildDir(javaPath, pkg, business, "controller.admin");
            target = path + File.separator + "Admin" + SimpleUtil.genName(tableName, 0) + ".java";
            this.genFile("/tpl/controller.tpl", (Map<?, ?>)data, new File(target));
            path = this.buildDir(tempPath, "/admin", business, SimpleUtil.genName(tableName, 0));
            target = path + File.separator + "list.html";
            this.genFile("/tpl/list.tpl", (Map<?, ?>)data, new File(target));
            path = this.buildDir(tempPath, "/admin", business, SimpleUtil.genName(tableName, 0));
            target = path + File.separator + "edit.html";
            this.genFile("/tpl/edit.tpl", (Map<?, ?>)data, new File(target));
        }
    }

    private String buildDir(String where, String pkg, String business, String t) {
        String path = new File("").getAbsolutePath() + (where + File.separator + (StrUtil.isEmptyIfStr((Object)pkg) ? "" : pkg + File.separator) + (StrUtil.isEmptyIfStr((Object)business) ? "" : business + File.separator) + t).replaceAll("\\.", File.separator);
        File file = new File(path);
        if (!file.exists() || file.isFile()) {
            file.mkdirs();
        }
        return path;
    }

    public void genFile(String tpl, Map<?, ?> data, File target) {
        Engine engine = Engine.use((String)"genUtil");
        if (engine == null) {
            engine = Engine.create((String)"genUtil");
            engine.setDevMode(true).setToClassPathSourceFactory();
            engine.addSharedMethod((Object)new StrUtil());
            engine.addSharedMethod((Object)new StrKit());
            engine.addSharedMethod((Object)new CollUtil());
            engine.addSharedMethod((Object)new SimpleUtil());
            engine.addDirective("now", NowDirective.class);
        }
        Template temp = engine.getTemplate(tpl);
        System.out.println(target.getAbsolutePath());
        temp.render(data, target);
    }
}

