const {createEditor, createToolbar} = window.wangEditor
const editorConfig = {
	MENU_CONF: {},
	placeholder: '',
	onChange(editor) {
		const html = editor.getHtml()
	}
}
editorConfig.MENU_CONF['uploadImage'] = {
	server: upfileURL,
	fieldName: 'file',
	index: '',
	maxFileSize: 10 * 1024 * 1024, // 10M
	// 最多可上传几个文件，默认为 100
	maxNumberOfFiles: 1,
	// 选择文件时的类型限制，默认为 ['image/*'] 。如不想限制，则设置为 []
	allowedFileTypes: ['image/*'],
	// 跨域是否传递 cookie ，默认为 false
	withCredentials: true,
	// 超时时间，默认为 10 秒
	timeout: 5 * 1000, // 5 秒
	// 单个文件上传成功之后
	// 上传之前触发
	onBeforeUpload(file) {      // JS 语法
		index = layer.load();
		return file
	},
	onError(file, err, res) {               // JS 语法
		layer.alert(`${file.name} ${err}`, {icon: 2});
	},
	customInsert(res, insertFn) {                  // JS 语法
		layer.close(index);
		if (res.code == 0) {
			// 从 res 中找到 url alt href ，然后插入图片
			url = res.data[0].url;
			alt = "图片";
			href = "链接地址";
			insertFn(url, alt, href)
		} else {
			layer.alert('上传图片失败', {icon: 2});
		}
	},
}
editorConfig.MENU_CONF['uploadVideo'] = {
	server: upfileURL,
	fieldName: 'file',
	index: '',
	maxFileSize: 1000 * 1024 * 1024, // 1000M
	// 最多可上传几个文件，默认为 5
	maxNumberOfFiles: 1,
	// 选择文件时的类型限制，默认为 ['video/*'] 。如不想限制，则设置为 []
	allowedFileTypes: ['video/*'],
	// 跨域是否传递 cookie ，默认为 false
	withCredentials: true,
	// 超时时间，默认为 30 秒
	timeout: 15 * 1000, // 15 秒
	onBeforeUpload(file) {      // JS 语法
		index = layer.load();
		return file
	},
	// 上传错误，或者触发 timeout 超时
	onError(file, err, res) {               // JS 语法
		layer.alert(`${file.name} ${err}`, {icon: 2});
	},
	// 视频不支持 base64 格式插入
	customInsert(res, insertFn) {// JS 语法
		layer.close(index);
		if (res.code == 0) {
			// 从 res 中找到 url poster ，然后插入视频
			url = res.data[0].url;
			insertFn(url)
		} else {
			layer.alert('上传视频失败', {icon: 2});
		}
	},
}
