package cn.miw.gen.utils;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;

import javax.sql.DataSource;

import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.ext.directive.NowDirective;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.json.JSONObject;

public class GenUtil {
	private DataSource ds;

	public GenUtil(DataSource ds) {
		super();
		this.ds = ds;
	}

	public void gen(String pkg, String business) {
		List<String> tables = ds!=null? MetaUtil.getTables(ds): null;
		gen(pkg, business, tables);
	}

	public void gen(String pkg, String business, List<String> tables) {
		gen(pkg, business, tables, "/src/main/java", "/src/main/resources/templates", true);
	}

	public void gen(String pkg, String business, List<String> tables, String javaPath, String tempPath,
			boolean override) {
		JSONObject data = new JSONObject().set("package", pkg);
		business = (StrUtil.isNotBlank(business) && !business.startsWith(".")) ? "." + business : business;
		if (tables != null)
			for (String tableName : tables) {
				data.set("tableName", tableName).set("business", business);
				Table tableMeta = MetaUtil.getTableMeta(ds, tableName);
				Set<String> pkNames = tableMeta.getPkNames();
				String pk = CollUtil.isNotEmpty(pkNames) ? pkNames.stream().findFirst().get() : null;
				Column pkCol = null;
				Collection<Column> fields = tableMeta.getColumns();
				if (pk != null) {
					pkCol = fields.stream().filter(x -> x.getName().equals(pk)).findFirst().get();
				} else
					pkCol = fields.stream().findFirst().get();
				data.set("fields", fields).set("pk", pkCol);

				String path, target;
				if (override) {
					path = buildDir(javaPath, pkg, business, "model");
					target = path + File.separator + SimpleUtil.genName(tableName, 0) + ".java";
					genFile("/tpl/model.tpl", data, new File(target));

					path = buildDir(javaPath, pkg, business, "mapper");
					target = path + File.separator + SimpleUtil.genName(tableName, 0) + "Mapper.java";
					genFile("/tpl/Mapper.tpl", data, new File(target));

					path = buildDir(javaPath, pkg, business, "service");
					target = path + File.separator + SimpleUtil.genName(tableName, 0) + "Service.java";
					genFile("/tpl/Service.tpl", data, new File(target));

					path = buildDir(javaPath, pkg, business, "service.impl");
					target = path + File.separator + SimpleUtil.genName(tableName, 0) + "ServiceImpl.java";
					genFile("/tpl/Impl.tpl", data, new File(target));

					path = buildDir(javaPath, pkg, business, "controller.admin");
					target = path + File.separator + "Admin" + SimpleUtil.genName(tableName, 0) + ".java";
					genFile("/tpl/controller.tpl", data, new File(target));

					path = buildDir(tempPath, "/admin", business, SimpleUtil.genName(tableName, 0));
					target = path + File.separator + "list.html";
					genFile("/tpl/list.tpl", data, new File(target));

					path = buildDir(tempPath, "/admin", business, SimpleUtil.genName(tableName, 0));
					target = path + File.separator + "edit.html";
					genFile("/tpl/edit.tpl", data, new File(target));
				}
			}

		processConfig(pkg, javaPath);
		processDefault(tempPath);
		processStatic(tempPath);
		processPOM(javaPath);

	}

	private void processPOM(String javaPath) {
//		File parent = new File(new File("").getAbsolutePath() + javaPath).getParentFile();
//		String pomxml = parent.getParentFile().getParent()+File.separator+"pom.xml";
//		System.out.println(pomxml);
//		Document pom = XmlUtil.readXML(new File(pomxml));
//		NodeList byXPath = (NodeList) XmlUtil.getByXPath("//project/dependencies", pom,  XPathConstants.NODESET);
//		for(int i=0;i<byXPath.getLength();i++) {
//			System.out.println(byXPath.item(i));
//		}
	}

	private void processStatic(String tempPath) {
		File parent = new File(new File("").getAbsolutePath() + tempPath).getParentFile();
		
		try (ZipInputStream zipInputStream = new ZipInputStream(ResourceUtil.getStream("static.zip"))) {
			File unzip = ZipUtil.unzip(zipInputStream, parent);
			System.out.println(unzip.getAbsolutePath()+File.separator+"static");
		} catch (NoResourceException | IOException e) {
			e.printStackTrace();
		};
	}

	private void processDefault(String tempPath) {
		JSONObject data = new JSONObject();
		String path, target;
		path = buildDir(tempPath, "/admin", "", "");
		target = path + File.separator + "_temp.html";
		File file = new File(target);
		if(!file.exists()) genFile("/tpl/default/_temp.html.tpl", data, file);
		target = path + File.separator + "index.html";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/default/index.html.tpl", data, file);
		target = path + File.separator + "welcome.html";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/default/welcome.html.tpl", data, file);
	}

	private void processConfig(String pkg, String javaPath) {
		JSONObject data = new JSONObject().set("package", pkg);
		String path, target;
		File file;
		path = buildDir(javaPath, pkg, "", "controller.admin");
		target = path + File.separator + "Index.java";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/default/Index.java.tpl", data, file);
		
		path = buildDir(javaPath, pkg, "", "config");
		target = path + File.separator + "MybatisPlusConfig.java";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/config/MybatisPlusConfig.java.tpl", data, file);
		
		target = path + File.separator + "JSONAop.java";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/config/JSONAop.java.tpl", data, file);
		
		target = path + File.separator + "ViewConfig.java";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/config/ViewConfig.java.tpl", data, file);
		
		target = path + File.separator + "AppConfig.java";
		file = new File(target);
		if(!file.exists()) genFile("/tpl/config/AppConfig.java.tpl", data, file);
	}

	private String buildDir(String where, String pkg, String business, String t) {
		String path = new File("").getAbsolutePath()
				+ (where + File.separator + (StrUtil.isEmptyIfStr(pkg) ? "" : pkg + File.separator)
						+ (StrUtil.isEmptyIfStr(business) ? "" : business + File.separator) + t)
						.replaceAll("\\.", File.separator);
		File file = new File(path);
		if (!file.exists() || file.isFile()) {
			file.mkdirs();
		}
		return path;
	}

	public void genFile(String tpl, Map<?, ?> data, File target) {
		Engine engine = Engine.use("genUtil");
		if (engine == null) {
			engine = Engine.create("genUtil");
			engine.setDevMode(true).setToClassPathSourceFactory();
			engine.addSharedMethod(new StrUtil());
			engine.addSharedMethod(new StrKit());
			engine.addSharedMethod(new CollUtil());
			engine.addSharedMethod(new SimpleUtil());
			engine.addDirective("now", NowDirective.class);
		}
		Template temp = engine.getTemplate(tpl);
		System.out.println(target.getAbsolutePath());
		temp.render(data, target);
	}

}
