package #(package).config;

import java.util.Random;

import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

import com.jfinal.kit.StrKit;
import com.jfinal.kit.TimeKit;
import com.jfinal.template.Engine;
import com.jfinal.template.ext.directive.NowDirective;
import com.jfinal.template.ext.spring.JFinalViewResolver;

import cn.hutool.json.JSONUtil;
/**
 * 基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架 <br>
 * @author mrzhou@miw.cn <br>
 * @date #now()
 * @see <a href="https://www.miw.cn/">来之里看看</a>
 */
@Configuration
public class ViewConfig {
	@Bean(name = "viewResolver")
	public ViewResolver getJFinalViewResolver() {

		ViewResolver jfr = new ViewResolver();

		jfr.setSuffix(".html");
		jfr.setContentType("text/html;charset=UTF-8");
		jfr.setOrder(0);

		jfr.setSessionInView(true);
		
		Engine engine = ViewResolver.engine;

		engine.setDevMode(true);
		Engine.setFastMode(true);
		Engine.setChineseExpression(true);

		engine.setToClassPathSourceFactory();
		engine.setCompressorOn();

		engine.setBaseTemplatePath("/templates/");
		

		return jfr;
	}
	
	public class ViewResolver extends JFinalViewResolver implements ApplicationListener<ContextRefreshedEvent> {
		private boolean inited = false;

		@Override
		public void onApplicationEvent(ContextRefreshedEvent event) {
			try {
				if (!inited) {
					inited = true;
					engine.addSharedObject("root", getServletContext().getContextPath());
					engine.addSharedMethod(new StrKit());
					engine.addSharedMethod(new Random());
					
					engine.addSharedObject("tk",new TimeKit());
					engine.addSharedObject("JSONUtil",new JSONUtil());
					engine.addDirective("now", NowDirective.class);
				}
			} catch (Exception e) {
			}

		}
	}
	
}
