#[[
<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width">
	<link rel="stylesheet" href="#(root)/static/libs/layui/css/layui.css">
	<link rel="stylesheet" href="#(root)/static/css/admin.css">
	<style>
		html, body { padding: 0; margin: 0; }
	</style>
</head>
<script src="#(root)/static/libs/layui/layui.js"></script>
<script>
	const root = '#(root)';
	let $, layer, table, util, element, dropdown, form;
	layui.use(['element', 'layer', 'util', 'table', 'dropdown', 'form'], () => {
		$ = layui.$, element = layui.element, layer = layui.layer, util = layui.util, table = layui.table, dropdown = layui.dropdown, form = layui.form;
		$.ajaxSetup({contentType: "application/json; charset=utf-8"});
		if (typeof init !== 'undefined') {
			init();
		}
	});
	function openWin(title, width, height, url){
		return layer.open({
			type: 2, title: title, closeBtn: 1, maxmin: true, shadeClose: false, scrollbar: true, fixed: false, moveOut: true,
			area: [width, height], //宽高
			content: url
		});
	}
	const post = (url, data, conf) => {
		return new Promise((resolve, reject) => {
			$.post({...conf, url: url, data: (!conf) ? JSON.stringify(data) : data}).then(res => {
				resolve(res);
			}).fail(() => {
				reject(`${url}接口出错`);
			});
		});
	}
	const _tableOption = {
		height: 'full-40'
		, method: 'post'
		, contentType: 'application/x-www-form-urlencoded'
		, defaultToolbar: ['filter', 'exports', 'print']
		, page: true //开启分页
		, limit: 50
		, limits: [50, 100, 200, 500, 1000]
		, parseData(res) {
			return {code: res.code, msg: res.message, count: res.data.total, data: res.data.records}
		}
	}
	const formToObject = form => Array.from(new FormData(form)).reduce((acc, [key, value]) => ({...acc, [key]: value}), {});
</script>

<body>
	<div>
		<span class="layui-breadcrumb">
			<a href="#(root)/admin" target="top">首页</a>
			<cite>#(active)</cite>
			<a class="layui-btn layui-btn-xs layui-layout-right" href="javascript:location.replace(location.href);" ctitle="刷新">
				<i class="layui-icon layui-icon-refresh-3"></i>
			</a>
		</span>
	</div>

	#render(pageName)
</body>

</html>
]]#