#[[
<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width">
	<title>我的系统</title>
	<link rel="stylesheet" href="#(root)/static/libs/layui/css/layui.css">
	<link rel="stylesheet" href="#(root)/static/css/admin.css">
	<!--[if lt IE 9]>
	<script src="#(root)/static/libs/js/html5.min.js"></script>
	<script src="#(root)/static/libs/js/respond.min.js"></script>
	<![endif]-->
</head>

<body>
	<div class="layui-layout layui-layout-admin">
		<div class="layui-header">
			<div class="layui-logo layui-hide-xs layui-bg-black">管理后台</div>
			<!-- 头部区域（可配合layui 已有的水平导航） -->
			<ul class="layui-nav layui-layout-left">
				<!-- 移动端显示 -->
				<li class="layui-nav-item layui-show-xs-inline-block layui-hide-sm" lay-menu-event="menuLeft">
					<i class="layui-icon layui-icon-spread-left"></i>
				</li>

				<li class="layui-nav-item layui-hide-xs"><a href="">nav 1</a></li>
				<li class="layui-nav-item layui-hide-xs"><a href="">nav 2</a></li>
				<li class="layui-nav-item layui-hide-xs"><a href="">nav 3</a></li>
				<li class="layui-nav-item">
					<a href="javascript:;">nav groups</a>
					<dl class="layui-nav-child">
						<dd><a href="">menu 11</a></dd>
						<dd><a href="">menu 22</a></dd>
						<dd><a href="">menu 33</a></dd>
					</dl>
				</li>
			</ul>
			<ul class="layui-nav layui-layout-right">
				<li class="layui-nav-item layui-hide layui-show-md-inline-block">
					<a href="javascript:;">
						<img src="#(root)/favicon.ico" class="layui-nav-img">
						管理员
					</a>
					<dl class="layui-nav-child">
						<dd><a href="">个人中心</a></dd>
						<dd><a href="">设置</a></dd>
						<dd><a href="">退出</a></dd>
					</dl>
				</li>
				<li class="layui-nav-item" lay-menu-event="menuRight" lay-unselect>
					<a href="javascript:;">
						<i class="layui-icon layui-icon-more-vertical"></i>
					</a>
				</li>
			</ul>
		</div>

		<div class="layui-side layui-bg-black">
			<div class="layui-side-scroll">
				<!-- 左侧导航区域（可配合layui已有的垂直导航） -->
				<ul class="layui-nav layui-nav-tree" lay-filter="test">
					<li class="layui-nav-item layui-nav-itemed">
						<a class="" href="javascript:;">系统管理</a>
						<dl class="layui-nav-child">
							<dd><a href="javascript:;" lay-menu-event="menuItem" data-id="999990" data-url="/admin/welcome">功能一</a></dd>
						</dl>
					</li>
					<li class="layui-nav-item">
						<a href="javascript:;">业务菜单</a>
						<dl class="layui-nav-child">
							<dd><a href="javascript:;" lay-menu-event="menuItem" data-id="999991" data-url="/admin/welcome">功能二</a></dd>
						</dl>
					</li>
					<li class="layui-nav-item"><a href="javascript:;" lay-menu-event="menuItem" data-id="999992" data-url="/admin/welcome">功能三</a></li>
				</ul>
			</div>
		</div>

		<div class="layui-body">
			<!-- 内容主体区域 -->
			<div class="page-content">
				<div class="layui-tab tab" lay-filter="xbs_tab" lay-allowclose="false">
					<ul class="layui-tab-title">
						<li>我的桌面</li>
					</ul>
					<div class="layui-tab-content">
						<div class="layui-tab-item layui-show">
							<iframe src='#(root)/admin/welcome' frameborder="0" scrolling="yes" class="x-iframe"></iframe>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="layui-footer">
			<!-- 底部固定区域 -->
			基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架，对生成的页面和代码只需稍加调整即可快速满足需求。author：mrzhou@miw.cn
		</div>
	</div>
	<script src="#(root)/static/libs/layui/layui.js"></script>
	<script>
		const root = '#(root)';
		var $, layer, table, util, element;
		layui.use(['element', 'layer', 'util','table'], function () {
			element = layui.element, layer = layui.layer, util = layui.util, $ = layui.$, table = layui.table;
			//头部事件
			util.event('lay-menu-event', {
				//左侧菜单事件
				menuLeft: function (othis) {
					layer.msg('展开左侧菜单的操作', {icon: 0});
				},
				menuRight: function () {
					layer.open({
						type: 1
						, content: '<div style="padding: 15px;">处理右侧面板的操作</div>'
						, area: ['260px', '100%']
						, offset: 'rt' //右上角
						, anim: 5
						, shadeClose: true
					});
				},
				menuItem(o) {
					title = $(o).text();
					id = $(o).data('id');
					url = $(o).data('url');
					if(url) tab.changeTab(url.startsWith('http')?url:root+url,title,id);
				}

			});

			var tab = {
				tabAdd: function (title, url, id) {
					url = url.indexOf('?')<0? (`${url}?title=${title}`):(`${url}&title=${title}`)
					element.tabAdd('xbs_tab', {
						title: title
						, content: `<iframe tab-id="${id}" frameborder="0" src="${url}" scrolling="yes" class="x-iframe"></iframe>`
						, id: id
					})
				},
				tabChange: function (id) {
					element.tabChange('xbs_tab', id);
					console.log('iframe',$('iframe').length);
				},
				changeTab: function (url, title, index) {
					for(item of $('.x-iframe')){
						if($(item).attr('tab-id') == index+1) {
							tab.tabChange(index + 1);
							return;
						}
					};
					tab.tabAdd(title, url, index + 1);
					tab.tabChange(index + 1);
				}
			};
		});
	</script>
</body>

</html>
]]#