/*
 * Decompiled with CFR 0.152.
 */
package cn.miw.gen.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.miw.gen.utils.SimpleUtil;
import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.jfinal.template.Template;
import com.jfinal.template.ext.directive.NowDirective;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import javax.sql.DataSource;

public class GenUtil {
    private DataSource ds;

    public GenUtil(DataSource ds) {
        this.ds = ds;
    }

    public void gen(String pkg, String business) {
        List tables = this.ds != null ? MetaUtil.getTables((DataSource)this.ds) : null;
        this.gen(pkg, business, tables);
    }

    public void gen(String pkg, String business, List<String> tables) {
        this.gen(pkg, business, tables, "/src/main/java", "/src/main/resources/templates", true);
    }

    private void gen(String pkg, String business, List<String> tables, String javaPath, String tempPath, boolean override) {
        JSONObject data = new JSONObject().set("package", (Object)pkg);
        business = StrUtil.isNotBlank((CharSequence)business) && !business.startsWith(".") ? "." + business : business;
        String staticDir = this.processStatic(tempPath);
        HashSet<JSONObject> menus = new HashSet<JSONObject>();
        if (tables != null && this.ds != null) {
            for (String tableName : tables) {
                Table tableMeta = MetaUtil.getTableMeta((DataSource)this.ds, (String)tableName);
                String comment = tableMeta.getComment();
                comment = StrKit.isBlank((String)comment) ? tableName : comment;
                String fix = StrKit.notBlank((String)business) ? business.substring(1) + "/" : "";
                String entityName = SimpleUtil.genName(tableName, 0);
                menus.add(new JSONObject().set("title", (Object)comment).set("url", (Object)("/admin/" + fix + entityName)));
                data.set("tableName", (Object)tableName).set("business", (Object)business).set("tableComment", (Object)comment);
                Set pkNames = tableMeta.getPkNames();
                String pk = CollUtil.isNotEmpty((Collection)pkNames) ? (String)pkNames.stream().findFirst().get() : null;
                Column pkCol = null;
                Collection fields = tableMeta.getColumns();
                pkCol = pk != null ? fields.stream().filter(x -> x.getName().equals(pk)).findFirst().get() : (Column)fields.stream().findFirst().get();
                data.set("fields", (Object)fields).set("pk", (Object)pkCol);
                String path = this.buildDir(javaPath, pkg, business, "model");
                String target = path + File.separator + SimpleUtil.genName(tableName, 0) + ".java";
                File file = new File(target);
                if (!file.exists() || file.exists() && override) {
                    this.genFile("/tpl/model.tpl", (Map<?, ?>)data, file);
                }
                if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, business, "mapper")) + File.separator + SimpleUtil.genName(tableName, 0) + "Mapper.java")).exists() || file.exists() && override) {
                    this.genFile("/tpl/Mapper.tpl", (Map<?, ?>)data, file);
                }
                if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, business, "service")) + File.separator + SimpleUtil.genName(tableName, 0) + "Service.java")).exists() || file.exists() && override) {
                    this.genFile("/tpl/Service.tpl", (Map<?, ?>)data, file);
                }
                if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, business, "service.impl")) + File.separator + SimpleUtil.genName(tableName, 0) + "ServiceImpl.java")).exists() || file.exists() && override) {
                    this.genFile("/tpl/Impl.tpl", (Map<?, ?>)data, file);
                }
                if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, business, "controller.admin")) + File.separator + "Admin" + SimpleUtil.genName(tableName, 0) + ".java")).exists() || file.exists() && override) {
                    this.genFile("/tpl/controller.tpl", (Map<?, ?>)data, file);
                }
                if (!(file = new File(target = (path = this.buildDir(tempPath, "/admin", business, SimpleUtil.genName(tableName, 0))) + File.separator + "list.html")).exists() || file.exists() && override) {
                    this.genFile("/tpl/list.tpl", (Map<?, ?>)data, file);
                }
                if ((file = new File(target = (path = this.buildDir(tempPath, "/admin", business, SimpleUtil.genName(tableName, 0))) + File.separator + "edit.html")).exists() && (!file.exists() || !override)) continue;
                this.genFile("/tpl/edit.tpl", (Map<?, ?>)data, file);
            }
        }
        String bussMenuName = StrKit.isBlank((String)business) ? "\u7cfb\u7edf\u4e1a\u52a1" : business.substring(1);
        this.processMenu(staticDir, bussMenuName, menus);
        this.processConfig(pkg, javaPath);
        this.processDefault(tempPath);
        this.processPOM(javaPath);
    }

    private void processMenu(String staticDir, String buess, Set<JSONObject> menus) {
        String path = staticDir + File.separator + "json/menu.json";
        File menuFile = new File(path);
        JSONObject oldMenu = menuFile.exists() ? JSONUtil.readJSONObject((File)menuFile, (Charset)Charset.forName("utf-8")) : new JSONObject();
        JSONArray array = oldMenu.getJSONArray((Object)buess);
        if (array == null) {
            array = new JSONArray();
        }
        array.addAll(menus);
        oldMenu.set(buess, (Object)array);
        FileUtil.writeUtf8String((String)oldMenu.toJSONString(0), (File)menuFile);
    }

    private void processPOM(String javaPath) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processStatic(String tempPath) {
        File parent = new File(new File("").getAbsolutePath() + tempPath).getParentFile();
        try (ZipInputStream zipInputStream = new ZipInputStream(ResourceUtil.getStream((String)"static.zip"));){
            File unzip = ZipUtil.unzip((ZipInputStream)zipInputStream, (File)parent);
            String string = unzip.getAbsolutePath() + File.separator + "static";
            return string;
        }
        catch (NoResourceException | IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void processDefault(String tempPath) {
        JSONObject data = new JSONObject();
        String path = this.buildDir(tempPath, "/admin", "", "");
        String target = path + File.separator + "_temp.html";
        File file = new File(target);
        if (!file.exists()) {
            this.genFile("/tpl/default/_temp.html.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "index.html")).exists()) {
            this.genFile("/tpl/default/index.html.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "welcome.html")).exists()) {
            this.genFile("/tpl/default/welcome.html.tpl", (Map<?, ?>)data, file);
        }
    }

    private void processConfig(String pkg, String javaPath) {
        JSONObject data = new JSONObject().set("package", (Object)pkg);
        String path = this.buildDir(javaPath, pkg, "", "controller.admin");
        String target = path + File.separator + "Index.java";
        File file = new File(target);
        if (!file.exists()) {
            this.genFile("/tpl/default/Index.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = (path = this.buildDir(javaPath, pkg, "", "config")) + File.separator + "MybatisPlusConfig.java")).exists()) {
            this.genFile("/tpl/config/MybatisPlusConfig.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "ViewConfig.java")).exists()) {
            this.genFile("/tpl/config/ViewConfig.java.tpl", (Map<?, ?>)data, file);
        }
        if (!(file = new File(target = path + File.separator + "AppConfig.java")).exists()) {
            this.genFile("/tpl/config/AppConfig.java.tpl", (Map<?, ?>)data, file);
        }
    }

    private String buildDir(String where, String pkg, String business, String t) {
        String x = where + File.separator + (StrUtil.isEmptyIfStr((Object)pkg) ? "" : pkg + File.separator) + (StrUtil.isEmptyIfStr((Object)business) ? "" : business + File.separator) + t;
        String path = new File("").getAbsolutePath() + x.replace(".", File.separator);
        File file = new File(path);
        if (!file.exists() || file.isFile()) {
            file.mkdirs();
        }
        return path;
    }

    private void genFile(String tpl, Map<?, ?> data, File target) {
        Engine engine = Engine.use((String)"genUtil");
        if (engine == null) {
            engine = Engine.create((String)"genUtil");
            engine.setDevMode(true).setToClassPathSourceFactory();
            engine.addSharedMethod((Object)new StrUtil());
            engine.addSharedMethod((Object)new StrKit());
            engine.addSharedMethod((Object)new CollUtil());
            engine.addSharedMethod((Object)new SimpleUtil());
            engine.addDirective("now", NowDirective.class);
        }
        Template temp = engine.getTemplate(tpl);
        System.out.println(target.getAbsolutePath());
        temp.render(data, target);
    }
}

