package #(package).config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import com.fasterxml.jackson.databind.ObjectMapper;

import cn.miw.gen.utils.JSONAop;
import cn.miw.gen.utils.SimpleUtil;

/**
 * 基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架 <br>
 * @author mrzhou@miw.cn <br>
 * @date #now() <br>
 * @see <a href="https://www.miw.cn/">来之里看看</a>
 */
@Configuration
public class AppConfig implements WebMvcConfigurer {
	@Bean
	public ObjectMapper objectMapper() {
		return SimpleUtil.objectMapper();
	}
	@Bean
	public JSONAop jsonAop() {
		return SimpleUtil.jsonAop();
	}

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry o) {
		o.addResourceHandler("/static/**").addResourceLocations("classpath:/static/");
	}

	@Override
	public void addInterceptors(InterceptorRegistry o) {
		String[] exStaticPaths = { "/static/**" };
	}

}
