package #(package).config;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

import cn.hutool.json.JSONObject;
/**
 * 基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架 <br>
 * @author mrzhou@miw.cn <br>
 * @date #now()
 * @see <a href="https://www.miw.cn/">来之里看看</a>
 */
@Aspect
public class JSONAop {

	@Around("@annotation(org.springframework.web.bind.annotation.ResponseBody)")
	public Object renderLog(ProceedingJoinPoint point) throws Throwable {
		Object result = exec(point);
		return result;
	}
	
	private Object exec(ProceedingJoinPoint point) throws Throwable {
		Object result = point.proceed();
		return new JSONObject(result);
	}
}
