package #(package).config;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
/**
 * 基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架 <br>
 * @author mrzhou@miw.cn <br>
 * @date #now()
 * @see <a href="https://www.miw.cn/">来之里看看</a>
 */
@Configuration
@MapperScan({ "**.mapper" })
public class MybatisPlusConfig {

	@Bean
	public MybatisPlusInterceptor mybatisPlusInterceptor() {
		MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
		interceptor.addInnerInterceptor(new PaginationInnerInterceptor());
		return interceptor;
	}

}