package #(package).config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.jfinal.template.Engine;

import cn.miw.gen.utils.ViewResolver;

/**
 * 基于springboot+mybatis-plus+enjoy+layui的增删改查基础框架 <br>
 * @author mrzhou@miw.cn <br>
 * @date #now() <br>
 * @see <a href="https://www.miw.cn/">来之里看看</a>
 */
@Configuration
public class ViewConfig {
	@Bean(name = "viewResolver")
	public ViewResolver getJFinalViewResolver() {

		ViewResolver jfr = new ViewResolver();

		jfr.setSuffix(".html");
		jfr.setContentType("text/html;charset=UTF-8");
		jfr.setOrder(0);

		jfr.setSessionInView(true);
		
		Engine engine = ViewResolver.engine;

		engine.setDevMode(true);
		Engine.setFastMode(true);
		Engine.setChineseExpression(true);

		engine.setToClassPathSourceFactory();
		engine.setCompressorOn();

		engine.setBaseTemplatePath("/templates/");
		

		return jfr;
	}
}
