package cn.miw.gen.utils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;

@SuppressWarnings("unchecked")
public class BaseController {
	@Autowired
	protected HttpServletRequest req;
	@Autowired
	protected HttpServletResponse resp;
	@Autowired
	protected HttpSession session;

	protected String active = "首页";

	public String render(String page) {
		return render(page, "/admin/_temp");
	}

	public String render(String page, String _temp) {
		setAttr("pageName", page);
		setAttr("active", active);
		return (page.endsWith(".html") ? _temp : page);
	}

	protected void setAttr(String k, Object v) {
		req.setAttribute(k, v);
	}

	protected <T> T getAttr(String k) {
		return (T) req.getAttribute(k);
	}

	protected void setSession(String k, Object v) {
		session.setAttribute(k, v);
	}

	protected void removeSession(String k) {
		session.removeAttribute(k);
	}

	protected <T> T getSession(String k) {
		return (T) session.getAttribute(k);
	}
}
