package cn.miw.gen.utils;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jfinal.kit.StrKit;

import cn.hutool.core.collection.CollUtil;

public class SimpleUtil {
	public static String getType(Integer type) {
		if (type.intValue() == 16)
			return Boolean.class.getName();

		else if (CollUtil.contains(Arrays.asList(4, 2), type))
			return Integer.class.getName();
		else if (CollUtil.contains(Arrays.asList(6, 8, 3), type))
			return Float.class.getName();
		else if (CollUtil.contains(Arrays.asList(5, -7, -6), type))
			return Byte.class.getName();
		else if (CollUtil.contains(Arrays.asList(70, 91, 92, 93, 2013, 2014), type))
			return Date.class.getName();
		else if (CollUtil.contains(Arrays.asList(12, -1, -9), type))
			return String.class.getName();
		else
			return String.class.getName();
	}

	public static String genName(String name, Integer f) {
		if (StrKit.isBlank(name)) return "";
		if(name.indexOf("_")<0 && name.toUpperCase().equals(name)) return name;
		String camelCase = StrKit.toCamelCase(name);
		return f.intValue() == 1 ? StrKit.firstCharToLowerCase(camelCase) : StrKit.firstCharToUpperCase(camelCase);
	}

	public static ObjectMapper objectMapper() {
		return new ObjectMapper()//
				.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)//
				.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)//
				.setSerializationInclusion(Include.NON_NULL)//
				.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
	}

}
