package cn.miw.gen.utils;

import java.util.Random;

import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

import com.jfinal.kit.StrKit;
import com.jfinal.kit.TimeKit;
import com.jfinal.template.ext.directive.NowDirective;
import com.jfinal.template.ext.spring.JFinalViewResolver;

import cn.hutool.json.JSONUtil;

public class ViewResolver extends JFinalViewResolver implements ApplicationListener<ContextRefreshedEvent> {
	private boolean inited = false;

	@Override
	public void onApplicationEvent(ContextRefreshedEvent event) {
		try {
			if (!inited) {
				inited = true;
				engine.addSharedObject("root", getServletContext().getContextPath());
				engine.addSharedMethod(new StrKit());
				engine.addSharedMethod(new Random());

				engine.addSharedObject("tk", new TimeKit());
				engine.addSharedObject("JSONUtil", new JSONUtil());
				engine.addDirective("now", NowDirective.class);
			}
		} catch (Exception e) {
		}

	}
}